<?php
/**
 * section-recipes-tops.php
 *
 * This file contains top recipes section
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */ ?>

<?php if (function_exists('get_field')){
    $section_style = ( get_sub_field('ps_rcpstps_style') ) ? ' '.get_sub_field('ps_rcpstps_style') : ' light' ;
    $per_page = ( get_sub_field('ps_rcpstps_perpage') ) ? (int)get_sub_field('ps_rcpstps_perpage') : 5 ;
} ?>

<?php global $pistacia_recipe_manager; ?>

<?php if ( !empty($pistacia_recipe_manager) ) : ?>

    <section class="hidden-print recipe-tops-section<?php echo esc_html($section_style);?>">
        <div class="recipe-tops-inner">
            <div class="container">
                <div class="col-md-3">
                    <div class="recipe-widget-box">
                        <h3 class="headline"><span><?php esc_html_e('Latest recipes','pistacia');?></span></h3>

                        <?php $pistacia_recipe_manager->the_most_recipes_posts(
                            array(
                                'posts_per_page' => $per_page,
                                'post_type'  => 'pistacia-recipes',
                                'orderby' => 'datetime',
                                'order'   => 'DESC'
                            )
                        );?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="recipe-widget-box">
                        <h3 class="headline"><span><?php esc_html_e('Fastest recipes','pistacia');?></span></h3>

                        <?php $pistacia_recipe_manager->the_most_recipes_posts(
                            array(
                                'posts_per_page' => $per_page,
                                'post_type'  => 'pistacia-recipes',
                                'orderby'    => 'meta_value_num',
                                'order'      => 'ASC',
                                'meta_query'      => array(
                                    'pistacia_recipe_cooktime' => array(
                                        'key'     => 'pistacia_recipe_alltime',
                                        'type'    => 'NUMERIC',
                                    ),
                                )
                            )
                        );?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="recipe-widget-box">
                        <h3 class="headline"><span><?php esc_html_e('Easily recipes','pistacia');?></span></h3>
                        <?php $pistacia_recipe_manager->the_most_recipes_posts(
                            array(
                                'posts_per_page' => $per_page,
                                'post_type'  => 'pistacia-recipes',
                                'orderby'    => 'meta_value_num',
                                'meta_key'   => 'pistacia_recipe_skill',
                                'order'      => 'ASC',
                            )
                        );?>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="recipe-widget-box">
                        <h3 class="headline"><span><?php esc_html_e('Difficulty recipes','pistacia');?></span></h3>
                        <?php $pistacia_recipe_manager->the_most_recipes_posts(
                            array(
                                'posts_per_page' => $per_page,
                                'post_type'  => 'pistacia-recipes',
                                'orderby'    => 'meta_value_num',
                                'meta_key'   => 'pistacia_recipe_skill',
                                'order'      => 'DESC',
                            )
                        );?>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php endif; ?>