<?php
/**
 * section-recipe-submit.php
 *
 * This file contains submit recipe section
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.4.0
 */ ?>

<?php $unique_id = uniqid(); ?>

<?php global $pistacia_recipe_manager; ?>

<?php if ( !empty($pistacia_recipe_manager) ) : ?>

    <section class="submit-recipe-section" style="background-image:url('<?php echo esc_url( Pistacia_Helpers::get_template_directory_uri() . '/assets/img/footer_background.jpg'); ?>');">
        <div class="overlay overlay-black-70"></div>
        <div class="container-inner">
            <div class="container">
                <div class="text-center">
                    <a
                        href="#"
                        class="btn btn-white submit-button submit-recipe-modal-show"
                        data-modal-id="#submit-recipe-modal-<?php echo esc_attr($unique_id); ?>"
                        data-unique-id="<?php echo esc_attr($unique_id); ?>">
                        <?php esc_html_e('Submit recipe','pistacia'); ?>
                    </a>
                </div>
            </div>
        </div>

        <div class="modal fade submit-recipe-modal-<?php echo esc_attr($unique_id); ?>"
             id="submit-recipe-modal-<?php echo esc_attr($unique_id); ?>"
             tabindex="-1"
             role="dialog"
             aria-labelledby="<?php esc_html_e('Submit recipe','pistacia'); ?>"
             data-unique-id="<?php echo esc_attr( $unique_id );?>">

            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="gridSystemModalLabel"><?php esc_html_e('Submit recipe','pistacia'); ?></h4>
                    </div>

                    <form
                        name="submit-recipe-form-<?php echo esc_attr($unique_id); ?>"
                        id="submit-recipe-form-<?php echo esc_attr($unique_id); ?>"
                        method="post"
                        action="">

                        <div class="modal-body modal-md">
                            <div class="row">
                                <div class="col-md-12">

                                    <div class="modal-body-inner">

                                        <ul class="nav nav-tabs" role="tablist">
                                            <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab"><?php esc_html_e('General','pistacia');?></a></li>
                                            <li role="presentation"><a href="#photos" aria-controls="photos" role="tab" data-toggle="tab"><?php esc_html_e('Photos','pistacia');?></a></li>
                                            <li role="presentation"><a href="#recipe" aria-controls="recipe" role="tab" data-toggle="tab"><?php esc_html_e('Recipe','pistacia');?></a></li>
                                            <li role="presentation"><a href="#properties" aria-controls="properties" role="tab" data-toggle="tab"><?php esc_html_e('Properties','pistacia');?></a></li>
                                            <li role="presentation"><a href="#author" aria-controls="author" role="tab" data-toggle="tab"><?php esc_html_e('Author','pistacia');?></a></li>
                                        </ul>

                                        <div class="tab-content">

                                            <div role="tabpanel" class="tab-pane active" id="general">

                                                <div class="form-group">
                                                    <label for="sbmt_recipe_title_<?php echo esc_attr( $unique_id );?>"><?php esc_html_e('Recipe title','pistacia');?></label>
                                                    <input type="text" class="form-control" id="sbmt-recipe-title-<?php echo esc_attr( $unique_id );?>" name="sbmt-recipe-title-<?php echo esc_attr( $unique_id );?>" placeholder="<?php esc_html_e('Title','pistacia');?>">
                                                </div>

                                                <div class="form-group">
                                                    <label for="sbmt_recipe_excerpt_<?php echo esc_attr( $unique_id );?>"><?php esc_html_e('Recipe excerpt','pistacia');?></label>
                                                    <textarea type="textarea" class="form-control" id="sbmt-recipe-excerpt-<?php echo esc_attr( $unique_id );?>" name="sbmt-recipe-excerpt-<?php echo esc_attr( $unique_id );?>" placeholder="<?php esc_html_e('Excerpt','pistacia');?>"></textarea>
                                                </div>

                                                <?php $categories = get_terms( array(
                                                    'taxonomy' => 'pistacia-recipes-categories',
                                                    'orderby'    => 'name',
                                                    'hide_empty' => false
                                                ) );?>

                                                <?php if(!empty($categories)) : ?>

                                                    <span class="bold"><?php esc_html_e('Categories','pistacia'); ?></span>

                                                    <?php foreach( $categories as $cat ) : ?>
                                                        <div class="checkbox">
                                                            <label>
                                                                <input class="sbmt-recipe-categories-<?php echo esc_attr( $unique_id );?>" name="sbmt-recipe-categories-<?php echo esc_attr( $unique_id );?>[]" value="<?php print $cat->term_id; ?>" type="checkbox"> <?php print $cat->name; ?>
                                                            </label>
                                                        </div>
                                                    <?php endforeach; ?>

                                                <?php endif; ?>

                                                <?php $cousines = get_terms( array(
                                                    'taxonomy' => 'pistacia-recipes-cousines',
                                                    'orderby'    => 'name',
                                                    'hide_empty' => false
                                                ) );?>

                                                <?php if(!empty($cousines)) : ?>

                                                    <span class="bold"><?php esc_html_e('Cousines','pistacia'); ?></span>

                                                    <?php foreach( $cousines as $cousine ) : ?>
                                                        <div class="checkbox">
                                                            <label>
                                                                <input class="sbmt-recipe-cousines-<?php echo esc_attr( $unique_id );?>" name="sbmt-recipe-cousines-<?php echo esc_attr( $unique_id );?>[]" value="<?php print $cousine->term_id; ?>" type="checkbox"> <?php print $cousine->name; ?>
                                                            </label>
                                                        </div>
                                                    <?php endforeach; ?>

                                                <?php endif; ?>

                                                <div class="form-group">

                                                    <label for="sbmt-recipe-tags-<?php echo esc_attr( $unique_id );?>"><?php esc_html_e('Recipe tags','pistacia');?></label>

                                                    <input
                                                        type="text"
                                                        class="form-control sbmt-recipe-tags-<?php echo esc_attr( $unique_id );?>"
                                                        id="sbmt-recipe-tags-<?php echo esc_attr( $unique_id );?>"
                                                        name="sbmt-recipe-tags-<?php echo esc_attr( $unique_id );?>">
                                                </div>


                                            </div>

                                            <div role="tabpanel" class="tab-pane" id="photos">

                                                <input type="file"
                                                       name="sbmt-recipe-featured-img-<?php echo esc_attr( $unique_id );?>"
                                                       id="sbmt-recipe-featured-img-<?php echo esc_attr( $unique_id );?>">

                                            </div>

                                            <div role="tabpanel" class="tab-pane" id="recipe">

                                            </div>

                                            <div role="tabpanel" class="tab-pane" id="properties">

                                            </div>

                                            <div role="tabpanel" class="tab-pane" id="author">

                                            </div>

                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">

                            <button
                                type="button"
                                class="btn btn-default"
                                data-loading-text="<?php esc_html_e('Loading','pistacia');?>..."
                                data-dismiss="modal">
                                <?php esc_html_e('Close','pistacia'); ?>
                            </button>

                            <input type="hidden" name="action" value="pistacia_ajax_submit_recipe">

                            <button
                                type="button"
                                data-unique-id="<?php echo esc_attr( $unique_id );?>"
                                class="btn btn-primary submit-recipe-button"
                                id="submit-recipe-button-<?php echo esc_attr( $unique_id );?>">
                                <?php esc_html_e('Submit recipe','pistacia'); ?>
                            </button>

                        </div>
                    </form>

                </div>
            </div>
        </div>


    </section>

<?php endif; ?>