<?php
/**
 * section-navigation.php
 *
 * This file contains top navigation
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */ ?>

<section id="pistacia-top-navigation" class="pistacia-top-navigation light">
    <nav class="navbar navbar-pistacia">
        <div class="container">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#top-menu-collapse" aria-expanded="false">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="sr-only"><?php esc_html_e('Toggle navigation','pistacia');?></span>
                </button>

                <?php pistacia_the_mobile_cart(); ?>

                <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <?php pistacia_the_brand_logo();?>
                </a>

            </div>

            <div class="collapse navbar-collapse " id="top-menu-collapse">

                <ul id="top-icons" class="nav navbar-nav navbar-right hidden-xs">
                    <li>
                        <a href="#" id="desktopSearchButton"><i class="fa fa-search"></i></a>
                    </li>
                    <?php Pistacia_Woocommerce::the_cart();?>
                </ul>

                <?php $navalign = ( function_exists('get_field') && get_field('pistacia_o_theme_setup_navalign','option') && get_field('pistacia_o_theme_setup_navalign','option') == 'right'  ) ? 'navbar-right' : 'navnar-left'; ?>

                <?php wp_nav_menu( array(
                        'menu'              => '',
                        'theme_location'    => 'top-menu',
                        'depth'             => 3,
                        'container'         => 'ul',
                        'container_class'   => 'collapse navbar-collapse',
                        'container_id'      => 'top-menu-collapse',
                        'menu_class'        => "nav navbar-nav top-menu $navalign",
                        'fallback_cb'       => 'Pistacia_Bootstrap_Navwalker::fallback',
                        'walker'            => new Pistacia_Bootstrap_Navwalker())
                ); ?>

                <div class="visible-xs mobile-search">
                    <?php pistacia_search_form_mobile();?>
                </div>

            </div>

            <div class="desktop-search" id="desktopSearch">
                <?php pistacia_search_form();?>
            </div>

        </div>
    </nav>

</section>