<?php
/**
 * section-footer.php
 *
 * This file contains section footer
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */ ?>

<?php $show_footer = true;
$show_footer = (function_exists('get_field') && get_field('pistacia_o_footer_hide','options') == 'hide') ? false : true; ?>

<?php if ( $show_footer == true ) : ?>

    <?php $footer_widgets = ( is_active_sidebar( 'pistacia_footer_widgets' ) ) ? true : false; ?>
    <?php $footer_img_src = (function_exists('get_field') && get_field('pistacia_footer_image','options')) ? get_field('pistacia_footer_image','options') : get_template_directory_uri() . '/assets/img/footer_background.jpg'; ?>

    <section class="footer-section hidden-print">

        <footer
            id="footer"
            class="footer"
            style="background-image:url('<?php echo esc_url( $footer_img_src ); ?>');">

<!--            <div class="overlay overlay-black-90"></div> -->

            <div class="container container-inner">

                <div class="row">

                    <?php if ( $footer_widgets ) : ?>

                        <?php if ( function_exists('get_field') && get_field('pistacia_o_footer_col','options') && get_field('pistacia_o_footer_col','options') != 4 ) {
                            $columns = get_field('pistacia_o_footer_col','options');
                        } ?>

                        <div class="footer-widgets<?php echo (!empty($columns)) ? ' footer-columns-' .$columns : ''; ?>">
                            <?php dynamic_sidebar('pistacia_footer_widgets');?>
                        </div>

                    <?php else : ?>

                        <?php get_template_part('partials/element','footer-columns'); ?>

                    <?php endif; ?>

                </div>

            </div>

        </footer>

    </section>

<?php endif; ?>