<?php
/**
 * section-bottom-bar.php
 *
 * This file contains footer bottom bar
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */ ?>

<?php $show_footer = true;
$show_footer = (function_exists('get_field') && get_field('pistacia_o_copyright_hide','options') == 'hide') ? false : true; ?>

<?php if ( $show_footer == true ) : ?>

    <section class="bottom-bar hidden-print" id="bottomBar">

        <a href="#pageTop" class="btn btn-white scroll-to"><i class="fa fa-chevron-up"></i></a>

        <div class="container">

            <div class="pull-left">
                <span class="small"><?php echo ( ( ( function_exists('get_field') ) && (get_field( 'pistacia_copyright', 'options' )) ) ) ? esc_html(get_field( 'pistacia_copyright', 'options' )) : '';?></span>
            </div>

            <div class="pull-right">
                <?php wp_nav_menu(array(
                    'theme_location' => 'footer-menu',
                    'menu_class' => 'clear bottom-menu',
                    'container' => 'ul',
                    'depth' => 1
                )); ?>
            </div>

        </div>

    </section>

<?php endif; ?>