<?php
/**
 * format-video.php
 *
 * This file contains video format.
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */?>

<?php if (function_exists('get_field')) : ?>
    <?php $featured_video = get_field('pistacia_featured_video'); ?>
<?php endif; ?>

<?php if( !empty( $featured_video ) ): ?>
    <div class="embed-responsive post-video embed-responsive-16by9">
        <?php the_field('pistacia_featured_video'); ?>
    </div>
<?php endif; ?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <div class="row">

        <div class="col-md-12">

            <a class="post-date" href="<?php the_permalink(); ?>">
                <span class="day"><?php echo esc_html(get_the_date('d',get_the_ID())); ?></span>
                <span class="month"><?php pistacia_the_month_name( get_the_date('m', get_the_ID()) ); ?></span>
            </a>

            <div class="post-like">
                <p><i class="fa fa-comments"></i></p>
                <span><?php $count = wp_count_comments( get_the_ID() ); echo esc_html($count->total_comments);?></span>
            </div>

            <div class="post-title">
                <h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                <span><?php esc_html_e('Posted by','pistacia');?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author();?></a></span>
            </div>

        </div>

    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="tagsandcategories">
                <?php esc_html_e('Categories','pistacia');?>: <?php the_category(', ');?>
                <?php esc_html_e('Tags','pistacia');?>: <?php the_tags(', ');?>
            </div>
            <div class="post-text">
                <?php the_excerpt(); ?>
            </div>
        </div>
    </div>

    <a href="<?php the_permalink(); ?>" class="button"><?php esc_html_e('Continue reading','pistacia');?></a>

</div>

<hr class="zigzag">
