<?php
/**
 * format-isotopepost.php
 *
 * This file contains format for isotope layout.
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */?>
<article class="post-article">

    <?php $img_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'medium' ); ?>
    <?php $img_link_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' ); ?>

    <?php if (function_exists('get_field')) : ?>
        <?php $featured_video = get_field('pistacia_featured_video'); ?>
    <?php endif; ?>

    <?php if( !empty( $featured_video ) ) : ?>
        <div class="embed-responsive post-video embed-responsive-16by9">
            <?php the_field('pistacia_featured_video'); ?>
        </div>
    <?php endif; ?>

    <?php if ( ( !empty( $img_url ) ) && ( empty( $featured_video ) ) ) : ?>

        <figure class="figure-hubba">

            <img src="<?php echo esc_url($img_url[0]);?>" class="img-responsive wait-for-load" alt="">

            <figcaption class="figcaption">
                <a href="<?php echo esc_url( $img_link_url[0] );?>" class="icon swipebox"><i class="fa fa-search"></i></a>
            </figcaption>

        </figure>

    <?php endif; ?>

    <header class="post-header clearfix">

     <!--   <div class="post-icons">
            <a href="#"><i class="fa fa-comments"></i> <?php $count = wp_count_comments( get_the_ID() ); echo esc_html($count->total_comments);?></a>
        </div> -->

        <h1><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h1>

      <!--  <div class="post-date">
            <a href="<?php the_permalink(); ?>">
                <i class="glyphicon glyphicon-time taxonomy-date"></i> <?php echo get_the_date( 'Y-m-d' ); ?> <?php the_time( 'H:i:s' ); ?>
            </a>
        </div> -->

       <!-- <div class="small post-author">
            <?php esc_html_e('Posted by','pistacia');?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author();?></a>
        </div> -->

    </header>

    <p><?php the_excerpt(); ?></p>

    <footer>

        <div class="text-center">
            <a style=" float: left; margin-top: 22px;" href="#"><i class="fa fa-comments"></i> <?php $count = wp_count_comments( get_the_ID() ); echo esc_html($count->total_comments);?></a>
            <a class="btn btn-more" href="<?php the_permalink();?>"><?php esc_html_e('Läs inlägg','pistacia'); ?></a>
        </div>

        <?php pistacia_the_share_buttons( get_permalink() );?>

    </footer>

</article>
