<?php /**
 * element-recipe-search-content.php
 *
 * This file contains recipes search content layout
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */?>

<?php global $pistacia_recipe_manager; ?>

<?php if ( !empty($pistacia_recipe_manager) ) : ?>

    <?php $taxomy = '';
    $current_term = '';
    $current_term_id = ''; ?>

    <?php if ( is_tax( 'pistacia-recipes-tags' ) || is_tax( 'pistacia-recipes-categories' ) || is_tax( 'pistacia-recipes-cousines' ) ){
        $taxomy = ( get_query_var( 'taxonomy' ) );
        $current_term = ( get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' )));
        $current_term_id = $current_term->term_id;
    } ?>

    <section class="recipe-boxes-section">
        <div class="container">
            <div class="recipe-boxes block-grid-<?php echo ( function_exists('get_field') && get_field('pistacia_o_recipes_columns','option') ) ? esc_attr( get_field('pistacia_o_recipes_columns','option') ) : '5';?>" id="recipe-boxes">
                <div class="recipes-container"
                     id="recipes-container"
                     data-default-postperpage="<?php echo ( function_exists('get_field') && get_field('pistacia_o_recipes_perpage','option') ) ? esc_attr( get_field('pistacia_o_recipes_perpage','option') ) : '10';?>"
                     data-default-paged="1"
                     data-termid="<?php echo esc_attr( $current_term_id ); ?>"
                     data-taxonomy="<?php echo esc_attr( $taxonomy ); ?>">
                </div>
                <div class="item-loading center-block text-center">
                    <img src="<?php echo get_template_directory_uri();?>/assets/img/loader_grey.gif">
                </div>
            </div>
        </div>
    </section>

    <section class="more-button-section">
        <div class="text-center">
            <a href="#" class="btn btn-append more-posts-button tool-tip"
               id="more-recipes-button"
               data-toggle="tooltip"
               data-placement="top"
               data-original-title="<?php esc_html_e('More recipes','pistacia');?>">
                <i class="fa fa-angle-down"></i>
            </a>
        </div>
    </section>

<?php endif; ?>