<?php
/**
 * elemen-recipe-search-bar.php
 *
 * This file contains recipes advanced search bar
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */?>

<?php global $pistacia_recipe_manager; ?>

<?php if ( !empty($pistacia_recipe_manager) ) : ?>

    <?php $cousines = get_terms( array(
        'taxonomy' => 'pistacia-recipes-cousines',
        'orderby'    => 'name',
        'hide_empty' => false
    ) );?>

    <?php $categories = get_terms( array(
        'taxonomy' => 'pistacia-recipes-categories',
        'orderby'    => 'name',
        'hide_empty' => false
    ) );?>

    <?php $tags = get_terms( array(
        'taxonomy' => 'pistacia-recipes-tags',
        'orderby'    => 'name',
        'hide_empty' => false
    ) );?>

    <section class="recipe-search-bar-section" id="recipe-search-bar-section">
        <div class="inner">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="recipes-search-box">
                            <a href="#" class="pistacia-recipes-reset-search" id="pistacia-recipes-reset-search"><?php esc_html_e('Reset all search','pistacia');?></a>
                            <div class="recipes-search-box-inner">
                                <div class="clearfix">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="pistacia-recipe-cousines"><?php esc_html_e('Cousines','pistacia');?></label>
                                            <select name="pistacia-recipe-cousines" id="pistacia-recipe-cousines" class="form-control">
                                                <option value="all"><?php esc_html_e('Any','pistacia');?></option>
                                                <?php foreach( $cousines as $cousine ) : ?>
                                                    <option value="<?php echo esc_attr($cousine->term_id); ?>"><?php echo esc_html($cousine->name); ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="pistacia-recipe-categories"><?php esc_html_e('Categories','pistacia');?></label>
                                            <select name="pistacia-recipe-categories" id="pistacia-recipe-categories" class="form-control">
                                                <option value="all"><?php esc_html_e('Any','pistacia');?></option>
                                                <?php foreach( $categories as $category ) : ?>
                                                    <option value="<?php echo esc_attr($category->term_id); ?>"><?php echo esc_html($category->name); ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="pistacia-recipe-categories"><?php esc_html_e('Tags','pistacia');?></label>
                                            <select name="pistacia-recipe-tags" id="pistacia-recipe-tags" class="form-control">
                                                <option value="all"><?php esc_html_e('Any','pistacia');?></option>
                                                <?php foreach( $tags as $tag ) : ?>
                                                    <option value="<?php echo esc_attr($tag->term_id); ?>"><?php echo esc_html($tag->name); ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label for="pistacia-recipe-categories"><?php esc_html_e('Keywords','pistacia');?></label>
                                            <input name="pistacia-recipe-keywords" id="pistacia-recipe-keywords" class="form-control" type="text">
                                        </div>
                                    </div>
                                    <div class="col-md-1">
                                        <button type="button" class="btn btn-primary btn-block" data-loading-text="..." id="pistacia-recipe-search-button"><i class="fa fa-search"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    <div class="pistacia-recipe-bar">
        <div class="container pistacia-recipe-bar-container">
            <div class="pistacia-recipe-bar-inner">
                <ul>
                    <li><span class="count" id="recipes-found"></span> <?php esc_html_e('recipes found','pistacia');?></li>
                </ul>
                <?php $pistacia_recipe_manager->the_favourite_button(); ?>
            </div>
        </div>
    </div>

<?php endif; ?>