<?php
/**
 * element-recipe-box.php
 *
 * This file contains recipe box layout
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */?>

<?php
$favourites = (!empty($_COOKIE['pistacia-recipes-favourites'])) ? $_COOKIE['pistacia-recipes-favourites'] : null ;
$favarr = (!empty($favourites)) ? explode( "," , $favourites ) : array();
$recipes_columns = get_field('pistacia_o_recipes_columns','option');
$columns = ( function_exists('get_field') && $recipes_columns ) ? $recipes_columns : '5';
$img_src = ($columns == 3) ? wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'large') : $img_src = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'medium');
?>

<div class="recipe-box">

    <div class="recipe-box-inner">
        <?php if (!empty($img_src[0])):?>
            <div class="photo">
                <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url( $img_src[0] );?>" class="img-responsive" alt=""></a>
                <?php if (function_exists('get_field')) : ?>
                    <?php $galleries = get_field('pistacia_recipe_gallery'); ?>
                    <?php if ( $galleries ) : ?>
                        <?php if ( count($galleries) > 0 ) : ?>
                            <span class="more-photo"><i class="fa fa-files-o"></i></span>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
                <a href="#"
                   class="recipe-add-to-favourite<?php echo ( in_array(get_the_ID(),$favarr) ) ? ' active' : '';?>"
                   data-recipe-post-id="<?php echo get_the_ID(); ?>"
                   data-toggle="tooltip" data-placement="left" title="<?php esc_html_e('add/remove favourite','pistacia');?>">
                    <i class="fa fa-heart"></i>
                </a>
            </div>
        <?php endif; ?>
        <div class="content">
            <h1 class="title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h1>
            <?php if (function_exists('get_field')) : ?>
                <?php $skills = get_field('pistacia_recipe_skill'); ?>
                <?php $icon = (function_exists('get_field') && get_field('pistacia_o_recipes_diff_symbol','option') ) ? get_field('pistacia_o_recipes_diff_symbol','option') : 'flaticon-meal2'; ?>
                <ul class="recipe-info-list text-center">
                    <?php if ( $skills ) : ?>
                        <li class="difficulty">
                            <?php for( $a=1; $a<= 5; $a++ ) : ?>
                                <i class="<?php echo esc_attr($icon);?><?php echo ( $a <= (int)$skills ) ? ' active' : ''; ?>"></i>
                            <?php endfor; ?>
                        </li>
                    <?php endif; ?>
                </ul>
            <?php endif; ?>
        </div>
    </div>
</div>

