<?php
/**
 * footer_columns.php
 *
 * This file contains footer hardcoded widgets from options
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.5.0
 */
?>
<?php $column = pistacia_get_footer_column_count();
if ( (function_exists('get_field')) && ( get_field('pistacia_footer_image','option') ) ) {
    $footer_img_src = get_field('pistacia_footer_image','option');
} ?>

<?php if ( function_exists('get_field') ) : ?>

    <?php if( get_field('pistacia_reviews','option') ) : ?>

        <div class="col-md-<?php echo esc_html($column); ?>">

            <h2><span class="light"><?php esc_html_e('Other said' , 'pistacia')?></span></h2>

            <?php pistacia_widget_testimony(); ?>

        </div>

    <?php endif; ?>

    <?php if( get_field('pistacia_op_times','options') ) : ?>

        <div class="col-md-<?php echo esc_html( $column ); ?>">

            <h2><span class="light"><?php esc_html_e('Operation time','pistacia');?></span></h2>

            <?php pistacia_widget_operationtime(); ?>

        </div>

    <?php endif; ?>

    <?php if ( pistacia_has_contacts() ) : ?>

        <div class="col-md-<?php echo esc_html( $column ); ?>">

            <h2><span class="light"><?php esc_html_e('Contact us','pistacia');?></span></h2>

            <?php pistacia_widget_contact(); ?>

        </div>

    <?php endif; ?>

    <?php if ( ( get_field('pistacia_footer_widget_text','options') ) && ( get_field('pistacia_footer_widget_title','options') ) ) : ?>

        <div class="col-md-<?php echo esc_html( $column ); ?> about-us">

            <?php if ( get_field('pistacia_footer_widget_title','options') ) : ?>
                <h2><span class="light"><?php the_field('pistacia_footer_widget_title','options');?></span></h2>
            <?php endif; ?>

            <?php pistacia_widget_footertext(); ?>

        </div>

    <?php endif; ?>

<?php endif; ?>