<?php
/**
 * aside.php
 *
 * This file contains aside.
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */?>
<div class="col-md-4 aside-right">

    <?php if ( function_exists('get_field') ) {
        $asides = get_field('ps_sdprpts_widgets');
    } ?>

    <?php if ( !function_exists('get_field') || is_archive() || is_category() || is_tag() || is_tag() || is_home() || ( !empty($asides) && in_array( 'categories', $asides ) ) ) : ?>
        <?php if( pistacia_has_categories() ):?>
            <div class="nav-side-menu small box light">
                <h3 class="headline"><span><?php esc_html_e('Categories','pistacia');?></span></h3>
                <?php pistacia_the_categories(); ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <?php if ( !function_exists('get_field') || is_archive() || is_category() || is_tag() || is_tag() || is_home() || ( !empty($asides) && in_array( 'archives', $asides ) ) ) : ?>
        <div class="nav-side-menu small box light">
            <?php pistacia_display_archives( $title = esc_html__('Archives','pistacia')  );?>
        </div>
    <?php endif; ?>

    <?php if ( !function_exists('get_field') || is_archive() || is_category() || is_tag() || is_tag() || is_home() || ( !empty($asides) && in_array( 'recentposts', $asides ) ) ) : ?>
        <?php pistacia_recent_posts(
            $title = esc_html__('Recent posts','pistacia'),
            $box_style = 'light',
            array(
                'posts_per_page' => 5,
                'offset' => 0,
                'category' => 0,
                'orderby' => 'post_date',
                'order' => 'DESC',
                'post_type' => 'post',
                'post_status' => 'publish',
                'suppress_filters' => true ), true ); ?>
    <?php endif; ?>

    <?php if ( !function_exists('get_field') || is_archive() || is_category() || is_tag() || is_tag() || is_home() || ( !empty($asides) && in_array( 'featuredproducts', $asides ) ) ) : ?>
        <?php Pistacia_Woocommerce::display_aside_products(
            $title = esc_html__('Featured products','pistacia'),
            $box_style = 'light',
            array(
                'post_type' => 'product',
                'meta_key' => '_featured',
                'meta_value' => 'yes',
                'posts_per_page' => '5'
            ) );?>
    <?php endif; ?>

    <?php if ( !function_exists('get_field') || is_archive() || is_category() || is_tag() || is_tag() || is_home() || ( !empty($asides) && in_array( 'recentimages', $asides ) ) ) : ?>
        <?php pistacia_recent_images(
            $title = esc_html__('Recent images','pistacia'),
            $box_style = 'light',
            $arr = array() ); ?>
    <?php endif; ?>

    <?php if ( !function_exists('get_field') || is_archive() || is_category() || is_tag() || is_tag() || is_home() || ( !empty($asides) && in_array( 'tags', $asides ) ) ) : ?>
        <?php pistacia_the_tags_widget( $title = esc_html__('Tags','pistacia'), $box_style = 'light', array() ); ?>
    <?php endif; ?>

</div>