<?php
/**
 * page.php
 *
 * This file contains page
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */?>

<?php $vc_enabled = get_post_meta(get_the_ID(), '_wpb_vc_js_status', true); ?>

<?php get_header();?>

<?php if ( function_exists('get_field') ) : ?>
    <?php if ( get_field( 'ps_header_img' ) ) : ?>
        <header class="header">
            <div class="header-img" style="background-image:url('<?php echo esc_url( get_field( 'ps_header_img' ) );?>')">
                <div class="overlay overlay-black-70"></div>
            </div>
        </header>
    <?php endif; ?>
<?php endif; ?>

<?php if ( have_posts() ) : the_post(); ?>

    <?php $aside = ( is_active_sidebar( 'pistacia_page_sb' ) ) ? true : false; ?>

    <section class="single-post">

        <div class="container">

            <div class="col-md-<?php echo $aside ? '10' : '12'; ?>">

                <div class="row">
                    <div class="col-md-12">
                        <h3 class="headline page-title"><span><?php the_title();?></span></h3>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="post-text">
                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <?php wp_link_pages(); ?>
                    </div>
                </div>

                <?php if ( pistacia_has_share_buttons() ) : ?>
                    <h5 class="text-center"><?php esc_html_e('Share this page','pistacia');?>:</h5>
                    <?php pistacia_the_share_buttons( get_permalink() );?>
                <?php endif; ?>

                <hr class="zigzag">

                <?php if ( comments_open() ){
                    comments_template();
                } ?>

            </div>

            <?php if ( $aside ) : ?>
                <div class="col-md-2 pistacia-aside">
                    <?php dynamic_sidebar( 'pistacia_page_sb' ); ?>
                </div>
            <?php endif; ?>

        </div>

    </section>

<?php endif; ?>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer();?>

