<?php /* Template Name: Page Builder */
/**
 * page-builder.php
 *
 * This file contains page builder
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
if( function_exists('get_field') ) {

    if (pistacia_get_gmap_row()) {
        add_action('get_header', 'pistacia_load_google_api');
    }

    get_header();

    /* If visual composer active */
    if ( get_post_meta(get_the_ID(), '_wpb_vc_js_status', true) ) {

        if ( have_posts() ) {?>
            <section class="visual-section">
                <div class="container">
                    <?php the_post();
                    the_content();?>
                </div>
            </section>
        <?php }

    }

    if( have_rows('ps_pg_builder') ){

        while( have_rows('ps_pg_builder') ) {

            the_row();

            $row_layout = get_row_layout();

            get_template_part( '/acf_pro/templates/'.$row_layout );

        }

    }

    get_template_part( 'partials/section', 'footer' );
    get_template_part( 'partials/section', 'bottom-bar' );

    get_footer();

}