<?php
/**
 * frontend.php
 *
 * Theme custom functions
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */



/**
 * pistacia_the_navbar_align_class
 *
 * Echo navbar align class
 *
 */
function pistacia_the_navbar_align_class(){
    if ( function_exists('get_field') && get_field('pistacia_o_theme_setup_navalign0','option') && get_field('pistacia_o_theme_setup_navalign0','option') == 'right' ){
        echo ' navbar-right';
    }
}

/**
 * @return array
 */
function pistacia_get_all_navmenus_array(){
    $nav_menus = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
    $ret = array();
    foreach ($nav_menus as $key => $value ){
        $ret[$value->name] = $value->slug;
    }
    return $ret;
}

/**
 * pistacia_boxed_before
 */
function pistacia_boxed_before(){
    $classes = get_body_class();
    if ( in_array( 'ps-boxed', $classes ) ) {
        echo '<div class="container page-wrapper">';
    }
}

/**
 * pistacia_boxed_after
 */
function pistacia_boxed_after(){
    $classes = get_body_class();
    if ( in_array( 'ps-boxed', $classes ) ) {
        echo '</div>';
    }
}

function pistacia_the_brand_logo(){ ?>
    <?php if ( get_theme_mod( 'ps_theme_brandlogo' ) ) : ?>
        <img class="responsive" src="<?php echo esc_url( get_theme_mod( 'ps_theme_brandlogo' ) ); ?>" alt="">
    <?php else:?>
        <img class="responsive" src="<?php echo get_template_directory_uri();?>/assets/img/logo/logo.png" alt="">
    <?php endif; ?>
<?php }




/**
 * pistacia_the_favicon
 *
 * Display all favicon
 *
 *
 * */
function pistacia_the_favicon() {

    if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {?>
        <link rel="shortcut icon" href="<?php echo esc_url( get_template_directory_uri() ) . '/assets/img/ico/favicon.ico'; ?>" type="image/x-icon" />
    <?php } else { ?>
        <?php wp_site_icon(); ?>
    <?php } ?>

<?php }




/**
 * pistacia_get_keywords
 *
 * @return string
 */
function pistacia_get_keywords(){

    $keywords = '';

    $tags = get_terms('post_tag');

    foreach ( $tags as $tag ){
        $keywords .= ','.$tag->slug;
    }

    $keywords = substr( $keywords, 1, 150 );

    return $keywords;
}



/**
 * pistacia_ajax_getposts
 *
 * For Isotope grid layouts
 *
 */
function pistacia_ajax_getposts(){ ?>

    <?php $arr = array();
    $spl = explode(',',$_POST['args']);
    foreach ( $spl as $value){
        $v = explode( '=', $value );
        $arr[$v[0]] = $v[1];
    } ?>

    <?php $query = new WP_Query( $arr ); ?>

    <?php while( $query->have_posts()) : $query->the_post();?>

        <?php $terms = get_the_terms( get_the_ID(),'category' ); ?>

        <div class="element-item <?php foreach( $terms as $term ){ echo esc_attr($term->slug).' '; } ?>" data-category="<?php foreach( $terms as $term ){ echo esc_attr($term->slug).' '; } ?>">
            <div class="inner">
                <?php get_template_part('partials/format', 'isotopepost'); ?>
            </div>
        </div>

    <?php endwhile; ?>

    <?php die(); ?>

<?php }

add_action( 'wp_ajax_pistacia_ajax_getposts', 'pistacia_ajax_getposts' );
add_action( 'wp_ajax_nopriv_pistacia_ajax_getposts', 'pistacia_ajax_getposts' );



/**
 * pistacia_has_socials
 *
 * return true if has socials
 *
 * @return bool
 */
function pistacia_has_socials() {
    if ( function_exists('get_field') ) {
        if ((get_field('pistacia_social_facebook', 'option')) ||
            (get_field('pistacia_social_googleplus', 'option')) ||
            (get_field('pistacia_social_twitter', 'option')) ||
            (get_field('pistacia_social_youtube', 'option')) ||
            (get_field('pistacia_social_skype', 'option'))
        ) {
            return true;
        }
    }
    return false;
}



/**
 * pistacia_the_reservation_select
 *
 * display reservation form hours select options
 *
 */
function pistacia_the_reservation_select( $items ){
    if( !empty( $items ) ){
        $aitems = explode( ',',$items );
        foreach ($aitems as $item){
            echo '<option value="' . esc_attr($item) . '">' . esc_html($item) . '</option>';
        }
    }
}



/**
 * pistacia_get_socials_list
 *
 * Get social links
 *
 * */
function pistacia_the_socials_list() { ?>

    <?php if ( function_exists('get_field') ) : ?>

        <ul>
            <?php if( get_field('pistacia_social_facebook','option') ): ?>
                <li><a class="socicon socicon-facebook" href="<?php echo esc_url( get_field('pistacia_social_facebook','option') ); ?>" title="<?php esc_html_e('Facebook','pistacia');?>"></a></li>
            <?php endif; ?>

            <?php if( get_field( 'pistacia_social_youtube','option') ): ?>
                <li><a class="socicon socicon-youtube" href="<?php echo esc_url( get_field('pistacia_social_youtube','option') ); ?>" title="<?php esc_html_e('Youtube','pistacia');?>"></a></li>
            <?php endif; ?>

            <?php if( get_field( 'pistacia_social_googleplus','option') ): ?>
                <li><a class="socicon socicon-google" href="<?php echo esc_url( get_field('pistacia_social_googleplus','option') ); ?>" title="<?php esc_html_e('Google plus','pistacia');?>"></a></li>
            <?php endif; ?>

            <?php if( get_field('pistacia_social_twitter','option') ): ?>
                <li><a class="socicon socicon-twitter" href="<?php echo esc_url( get_field('pistacia_social_twitter','option') ); ?>" title="<?php esc_html_e('Twitter','pistacia');?>"></a></li>
            <?php endif; ?>

            <?php if( get_field( 'pistacia_social_skype','option') ): ?>
                <li><a class="socicon socicon-skype" href="<?php echo esc_url( get_field('pistacia_social_skype','option') ); ?>" title="<?php esc_html_e('Skype','pistacia');?>"></a></li>
            <?php endif; ?>
        </ul>

    <?php endif; ?>

<?php }



/**
 * pistacia_has_contacts
 *
 * @return bool
 */

function pistacia_has_contacts(){

    if ( function_exists('get_field') ) {

        if ((get_field('pistacia_contact_email', 'option')) ||
            (get_field('pistacia_contact_address', 'option')) ||
            (get_field('pistacia_contact_phone', 'option'))
        ) {
            return true;
        }
        return false;
    }
}



/**
 * pistacia_get_footer_column_count
 *
 * @return float
 */
function pistacia_get_footer_column_count(){

    $column_count = 0;

    if ( function_exists('get_field') ) {

        if ( get_field('pistacia_reviews', 'option') ) {
            $column_count++;
        }
        if ( get_field('pistacia_op_times', 'options') ) {
            $column_count++;
        }
        if ( pistacia_has_contacts() ) {
            $column_count++;
        }
        if ( get_field('pistacia_footer_widget_title', 'options') && get_field('pistacia_footer_widget_text', 'options') ) {
            $column_count++;
        }

    }

    if ( $column_count != 0 ) {
        return 12 / $column_count;
    } else {
        return 12;
    }

}



/**
 * pistacia_search_form
 *
 * Display search form
 *
 * @param $form
 * @return string
 */
function pistacia_search_form() {?>

    <form role="search" method="get" id="searchform" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">

        <div class="input-group">
            <span class="input-group-btn"><button class="btn btn-default" id="desktopSearchClose" type="button"><i class="fa fa-close"></i></button></span>
            <input type="text" class="form-control searchField" placeholder="<?php esc_html_e('Search','pistacia');?>..." value="<?php echo get_search_query(); ?>" name="s" id="search-desktop">
            <span class="input-group-btn"><button class="btn btn-default" type="submit" id="searchsubmit"><i class="fa fa-search"></i></button></span>
        </div>

    </form>

    <?php remove_filter( 'get_search_form', 'pistacia_search_form' ); ?>

<?php }

add_filter( 'get_search_form', 'pistacia_search_form' );



/**
 * pistacia_search_form_mobile
 *
 * Display search form
 *
 * @param $form
 * @return string
 */
function pistacia_search_form_mobile() {?>

    <form role="search" method="get" id="searchformmobile" class="searchformmobile" action="<?php echo esc_url( home_url( '/' ) ); ?>">

        <div class="input-group">
            <input type="text" class="form-control" value="<?php echo esc_attr(get_search_query());?>" name="s" id="search-mobile">
            <span class="input-group-btn">
                <button class="btn btn-primary" type="submit" id="searchsubmitmobile"><i class="fa fa-search"></i></button>
            </span>
        </div>

    </form>

    <?php remove_filter( 'get_search_form', 'pistacia_search_form_mobile' ); ?>

<?php }

add_filter( 'get_search_form', 'pistacia_search_form_mobile' );



/** pistacia_set_posts_per_page_search
 * @param $query
 * @return mixed
 */
function pistacia_set_posts_per_page_search( $query ) {

    global $wp_the_query;

    if ( ( ! is_admin() ) && ( $query === $wp_the_query ) && ( $query->is_search() ) ) {
        $query->set( 'posts_per_page', 20 );
    }
    return $query;
}

add_action( 'pre_get_posts',  'pistacia_set_posts_per_page_search' );



/**
 * pistacia_get_attachment_acf_image
 *
 * @param $image
 */
function pistacia_get_attachment_acf_image( $image ){

    if( !empty( $image ) ){

        $url = $image['url'];
        $title = $image['title'];
        $alt = $image['alt'];
        $size = 'thumbnail';
        $thumb = $image['sizes'][ $size ];?>

        <a href="<?php echo esc_url($url); ?>" class="swipebox">
            <img class="img-responsive img-circle" src="<?php echo esc_url($thumb); ?>" alt="<?php echo esc_attr($alt); ?>" />
        </a>

    <?php } ?>

<?php }



/**
 * pistacia_get_gmap_row
 *
 * Return if has google map in builder page
 *
 * @return bool
 */
function pistacia_get_gmap_row(){

    $is_gmap = false;

    if( get_field('ps_pg_builder') ) {
        foreach ( get_field('ps_pg_builder') as $r) {
            if ( in_array('ps_bldr_contact', $r, true) || in_array('ps_bldr_gmap', $r, true) ) {
                $is_gmap = true;
            }
        }
    }

    return $is_gmap;

}



/**
 * pistacia_load_google_api
 *
 * Load Google api
 *
 */
function pistacia_load_google_api(){

    $key = '';

    if ( function_exists( 'get_field' ) && ( get_field( 'pistacia_contact_map_api_key', 'options' ) ) ) {
        $key = get_field( 'pistacia_contact_map_api_key' , 'options' );
    }

    wp_enqueue_script('google-api','https://maps.googleapis.com/maps/api/js?key=' . $key,array(), Pistacia_Helpers::get_theme_version(),true);

}



/**
 * pistacia_has_share_buttons
 *
 * Return true if one share button is active
 *
 * @return bool
 *
 */
function pistacia_has_share_buttons(){

    if ( function_exists('get_field') ) {
        if ( ( get_field( 'pistacia_social_facebook_shbutton', 'options' ) ) ||
            ( get_field( 'pistacia_social_googleplus_shbutton', 'options' ) ) ||
            ( get_field( 'pistacia_social_twitter_shbutton', 'options' ) )
        ) {
            return true;
        }
    }

}


/**
 * pistacia_the_share_buttons
 *
 * Get social share button
 *
 * */
function pistacia_the_share_buttons( $link ) { ?>

    <?php if ( function_exists('get_field') ) : ?>

        <div class="socialbar socialbar-inner socialbar-radius colorizesocial text-center">

            <ul>
                <?php if ( get_field( 'pistacia_social_facebook_shbutton','options' ) ) : ?>
                    <li class="facebook"><a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url( $link );?>" target="_blank" class="socicon socicon-facebook social-share-button hvr-buzz-out"></a></li>
                <?php endif; ?>

                <?php if (get_field('pistacia_social_googleplus_shbutton','options')) :?>
                    <li class="googleplus"><a href="https://plus.google.com/share?url=<?php echo esc_url( $link );?>" class="socicon socicon-google social-share-button hvr-buzz-out"></a></li>
                <?php endif; ?>

                <?php if (get_field('pistacia_social_twitter_shbutton','options')) :?>
                    <li class="twitter"><a href="https://twitter.com/home?status=<?php echo esc_url( $link ) ;?>" class="socicon socicon-twitter social-share-button hvr-buzz-out"></a></li>
                <?php endif; ?>
            </ul>

        </div>

    <?php endif; ?>

<?php }



/**
 * pistacia_the_tags_widget
 *
 */
function pistacia_the_tags_widget( $title = '', $box_style = 'light', $args = array() ){

    $tags = get_tags($args);

    $box_title = ($title!='') ? $title : esc_html__('Tags','pistacia') ;

    if ( !empty( $tags ) ):?>

        <div class="tags-widget <?php echo esc_html($box_style); ?>">

            <?php if ( $title != '' ) : ?>
                <h3 class="headline"><span><?php echo esc_html($box_title);?></span></h3>
            <?php endif; ?>

            <ul class="tags clearfix">

                <?php foreach( $tags as $tag ) : ?>

                    <li><a href="<?php echo esc_url( get_tag_link( $tag->term_id ) );?>"><?php echo esc_html( $tag->name ); ?></a></li>

                <?php endforeach; ?>

            </ul>

        </div>

    <?php endif;?>


<?php }


/**
 * pistacia_the_stars
 *
 */
function pistacia_the_stars( $number ){ ?>
    <div class="stars">
        <?php for( $a=1; $a<= 5; $a++) : ?>
            <?php if ( $number >= $a ) : ?>
                <a href="#"><i class="fa fa-star"></i></a>
            <?php else: ?>
                <a href="#"><i class="fa fa-star-o"></i></a>
            <?php endif; ?>
        <?php endfor; ?>
    </div>
<?php }



/**
 * pistacia_the_mobile_cart
 *
 */
function pistacia_the_mobile_cart(){
    global $woocommerce; ?>
    <?php if ( $woocommerce ) : ?>
        <a href="<?php echo esc_url( $woocommerce->cart->get_cart_url() ); ?>" class="btn-cart-xs visible-xs">
            <i class="fa fa-shopping-cart primary-color"></i>
            <span><?php echo esc_html($woocommerce->cart->cart_contents_count);?></span>
        </a>
    <?php endif; ?>
<?php }



/**
 * pistacia_recent_posts
 *
 * @param string $title
 * @param string $box_style
 * @param array $args
 * @param bool $display
 * @return bool
 */
function pistacia_recent_posts(
    $title = '',
    $box_style = 'light',
    $args = array(),
    $display = true ){?>

    <?php $recent_posts = new WP_Query( $args ); ?>

    <?php if ( $recent_posts->have_posts() ) : ?>

        <?php if ( $display ) : ?>

            <div class="popular-widget clearfix <?php echo esc_html($box_style); ?>">

                <?php if ( $title != '' ) : ?>
                    <h3 class="headline"><span><?php echo esc_html( $title );?></span></h3>
                <?php endif; ?>

                <?php while ( $recent_posts->have_posts() ) : $recent_posts->the_post(); ?>

                    <article class="item row">

                        <?php $img_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'thumbnail' ); ?>
                        <?php $img_big = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' ); ?>

                        <?php if ( !empty( $img_url ) ):?>
                            <div class="col-md-4">
                                <a href="<?php the_permalink();?>">
                                    <figure class="figure-hubba">
                                        <img src="<?php echo esc_url($img_url[0]);?>" class="img-responsive wait-for-load" alt="">
                                        <figcaption class="figcaption">
                                            <span class="icon"><i class="fa fa-search"></i></span>
                                        </figcaption>
                                    </figure>
                                </a>
                            </div>
                        <?php endif; ?>


                        <div class="col-md-<?php echo (!empty( $img_url ) ) ? '8' : '12'; ?>">

                            <h1><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h1>
                            <span class="date"><?php the_time( get_option( 'date_format' ) ); ?></span>

                            <p><?php echo esc_html( substr( get_the_excerpt(), 0,60 ) ); ?>...</p>

                            <a href="<?php the_permalink();?>"><?php esc_html_e('more','pistacia');?></a>

                        </div>

                    </article>

                <?php endwhile; ?>

            </div>

        <?php endif; ?>

        <?php return true; ?>

    <?php endif; ?>

    <?php return false; ?>

<?php }



/**
 * pistacia_recent_images
 *
 * @param string $title
 * @param string $box_style
 * @param array $arr
 */
function pistacia_recent_images(
    $title = '',
    $box_style = 'light',
    $arr = array(
        'posts_per_page' => 9,
        'orderby' => 'post_date',
        'order' => 'DESC') ){ ?>

    <?php $args_default = array(
        'offset' => 0,
        'category' => 0,
        'post_type' => 'post',
        'post_status' => 'publish',
        'suppress_filters' => true,
        'meta_query' => array(
            array(
                'key' => '_thumbnail_id'
            ),
        ),
        'tax_query' => array(
            array(
                'taxonomy' => 'post_format',
                'terms' => array(
                    'post-format-video'
                ),
                'operator' => 'NOT IN'
            )
        )
    );?>

    <?php $args = array_merge($arr,$args_default);?>

    <?php $recent_posts = new WP_Query( $args ); ?>

    <?php if ( $recent_posts->have_posts() ) : ?>

        <div class="mini-gallery clearfix <?php echo esc_html($box_style); ?>">

            <?php if ( $title != '' ) : ?>
                <h3 class="headline"><span><?php echo esc_html($title);?></span></h3>
            <?php endif; ?>

            <ul class="gallery-items clearfix">

                <?php while ( $recent_posts->have_posts() ) : $recent_posts->the_post(); ?>

                    <?php $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'thumbnail' ); ?>
                    <?php $large_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' ); ?>

                    <?php if ( $thumbnail_src ) : ?>

                        <li>

                            <figure class="figure-hubba">
                                <img src="<?php echo esc_url($thumbnail_src[0]);?>" class="img-responsive wait-for-load" alt="">
                                <figcaption class="figcaption">
                                    <a href="<?php echo esc_url($large_src[0]);?>" class="icon swipebox" rel="recent_photos_gallery"><i class="fa fa-search"></i></a>
                                </figcaption>
                            </figure>

                        </li>

                    <?php endif; ?>

                <?php endwhile; ?>

            </ul>

        </div>

    <?php endif; ?>

<?php }


function pistacia_widget_testimony(){?>

    <?php if ( function_exists('get_field') ) : ?>

        <div class="swiper-container reviews-swiper-container">

            <div class="swiper-wrapper">

                <?php if ( get_field('pistacia_reviews','option') ) : ?>

                    <?php foreach ( get_field('pistacia_reviews','option') as $rev ) : ?>

                        <div class="swiper-slide">

                            <div class="row">

                                <?php if ( $rev['pistacia_review_img'] ) : ?>
                                    <div class="col-sm-4">
                                        <?php pistacia_get_attachment_acf_image( $rev['pistacia_review_img'] ); ?>
                                    </div>
                                <?php endif; ?>

                                <div class="col-sm-<?php echo ( $rev['pistacia_review_img'] ) ? '8' : '12'; ?>">
                                    <i class="fa fa-quote-left"></i> <?php echo esc_html($rev['pistacia_review_desc']);?> <i class="fa fa-quote-right"></i>
                                    <br><br><small><?php echo esc_html( $rev['pistacia_review_name'] );?></small>
                                </div>

                            </div>

                        </div>

                    <?php endforeach; ?>

                <?php endif; ?>

            </div>

        </div>

    <?php endif; ?>

<?php }


function pistacia_widget_operationtime(){?>

    <?php if ( function_exists('get_field') ) : ?>

        <?php if( get_field('pistacia_op_times','options') ) : ?>
            <ul class="contacts">
                <?php foreach ( get_field('pistacia_op_times','options') as $optime ) : ?>
                    <li><i class="fa fa-clock-o"></i> <?php echo esc_html( $optime['pistacia_op_time_title'] ); ?> <span class="bold clock"><?php echo esc_html( $optime['pistacia_op_time_time'] );?></span></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>

    <?php endif; ?>

<?php }


function pistacia_widget_footertext(){?>

    <?php if ( function_exists('get_field') ) : ?>
        <?php if ( get_field('pistacia_footer_widget_text','options') ) : ?>
            <div><?php the_field('pistacia_footer_widget_text','options');?></div>
        <?php endif; ?>
    <?php endif; ?>

<?php }


function pistacia_widget_contact(){?>

    <?php if ( function_exists('get_field') ) : ?>
        <?php if ( pistacia_has_contacts() ) : ?>
            <ul class="contacts">
                <li><i class="fa fa-map-marker"></i><?php the_field('pistacia_contact_address','options');?></li>
                <li><i class="fa fa-phone"></i><?php the_field('pistacia_contact_phone','options');?></li>
                <li><i class="fa fa-envelope"></i><a href="mailto:<?php echo esc_html( antispambot( get_field( 'pistacia_contact_email','options' ) ) ); ?>"><?php echo esc_html( antispambot( get_field( 'pistacia_contact_email','options' ) ) ); ?></a></li>
            </ul>
        <?php endif; ?>
    <?php endif; ?>
<?php }



/**
 * pistacia_has_categories
 *
 * Return true if has categories
 *
 * @return bool
 */
function pistacia_has_categories(){

    $categories = get_categories( array( 'parent' => 0 ) );

    if ( !empty( $categories ) ){
        return true;
    }

    return false;

}



/**
 * pistacia_the_categories
 *
 * Dsiplay all categories in frontend
 *
 */
function pistacia_the_categories(){

    $categories = get_categories( array( 'parent' => 0 ) );

    if ( !empty( $categories ) ) : ?>

        <ul class="collapse-menu">

            <?php foreach( $categories as $category ):?>

                <li>
                    <a href="<?php echo esc_url( get_category_link( $category->cat_ID ) );?>"><?php echo esc_html( $category->name ); ?></a>
                    <?php $sub_categories = get_categories( array(
                        'parent' => $category->cat_ID));
                    if ( !empty($sub_categories) ): ?>
                        <ul>
                            <?php foreach($sub_categories as $sub_category):?>
                                <li>
                                    <a href="<?php echo esc_url( get_category_link( $sub_category->cat_ID ) );?>"><?php echo esc_html( $sub_category->name ); ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                </li>

            <?php endforeach; ?>

        </ul>

    <?php endif; ?>

<?php }



/**
 * pistacia_display_archives
 *
 * display archives with title in frontend
 */
function pistacia_display_archives( $title = '' ){ ?>

    <?php $count_posts = wp_count_posts();

    if ( $count_posts->publish > 0) : ?>

        <?php if ( $title != '' ) : ?>
            <h3 class="headline"><span><?php echo esc_html( $title ); ?></span></h3>
        <?php endif; ?>

        <ul class="archives">

            <?php wp_get_archives( array(
                    'type' => 'monthly',
                    'limit' => '',
                    'format' => 'html',
                    'before' => '',
                    'after' => '',
                    'show_post_count' => false,
                    'echo' => true,
                    'order' => 'DESC')
            ); ?>

        </ul>

    <?php endif; ?>

<?php }



/**
 * pistacia_comment
 *
 * Display comment item
 *
 * @param $comment
 * @param $args
 * @param $depth
 */
function pistacia_comment( $comment, $args, $depth ) {?>

    <?php $GLOBALS['comment'] = $comment; ?>

<li <?php comment_class('item'); ?> id="li-comment-<?php comment_ID() ?>">

    <div class="inner row">

        <div class="photo col-sm-3">
            <div class="img-wrapper">
                <?php echo get_avatar( get_comment_author_email(),400 );?>
            </div>
        </div>

        <div class="info col-sm-9">
            <h3 class="comment-name"><?php comment_author();?></h3>
            <span class="date"><i class="fa fa-calendar"></i> on <?php comment_date();?> <?php comment_time();?></span>
            <div class="comment-text"><?php comment_text();?></div>
            <?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
        </div>

        <?php if ( $comment->comment_approved == '0' ) : ?>
            <em><?php esc_html_e( 'Your comment is awaiting moderation.', 'pistacia' ); ?></em>
        <?php endif; ?>

        <article class="clearfix" id="comment-<?php comment_ID(); ?>"></article>

    </div>

<?php }



/**
 * pistacia_get_month_name
 *
 * Display translated month name
 *
 * @param $month
 */
function pistacia_the_month_name( $month ) {

    $months = array(
        '1'   =>  esc_html__('Jan','pistacia'),
        '2'   =>  esc_html__('Feb','pistacia'),
        '3'   =>  esc_html__('Mar','pistacia'),
        '4'   =>  esc_html__('Apr','pistacia'),
        '5'   =>  esc_html__('May','pistacia'),
        '6'   =>  esc_html__('Jun','pistacia'),
        '7'   =>  esc_html__('Jul','pistacia'),
        '8'   =>  esc_html__('Aug','pistacia'),
        '9'   =>  esc_html__('Sep','pistacia'),
        '01'   =>  esc_html__('Jan','pistacia'),
        '02'   =>  esc_html__('Feb','pistacia'),
        '03'   =>  esc_html__('Mar','pistacia'),
        '04'   =>  esc_html__('Apr','pistacia'),
        '05'   =>  esc_html__('May','pistacia'),
        '06'   =>  esc_html__('Jun','pistacia'),
        '07'   =>  esc_html__('Jul','pistacia'),
        '08'   =>  esc_html__('Aug','pistacia'),
        '09'   =>  esc_html__('Sep','pistacia'),
        '10'  =>  esc_html__('Oct','pistacia'),
        '11'  =>  esc_html__('Nov','pistacia'),
        '12'  =>  esc_html__('Dec','pistacia')
    );

    echo esc_html($months[$month]);

}
