<?php /**
 * functions.php
 *
 * This file contains theme initialize
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

/**
 * Class autoloader
 */
function pistacia_autoloader( $className )  {
    $file = get_template_directory() . '/class/' . strtolower($className) . '.php';
    if( file_exists( $file ) ) {
        require_once( $file );
    }
}
spl_autoload_register('pistacia_autoloader');

Pistacia_Helpers::get_instance();
Pistacia_Tgm::get_instance();
Pistacia_Visual_Composer::get_instance();
Pistacia_Customize::get_instance();
Pistacia_Icons::get_instance();
Pistacia_Acf_Pro::get_instance();
Pistacia_Woocommerce::get_instance();
Pistacia_Ajax_Forms::get_instance();

/* Font family */
Pistacia_Google_Fonts::get_instance()->run();

/* Theme color */
$pistacia_theme_color = Pistacia_Theme_Color::get_instance();
$pistacia_theme_color->set_colors( array(
    'theme_color' => ( function_exists('get_field') && get_field('pistacia_o_primary_color','option') ) ? get_field('pistacia_o_primary_color','option') : '',
    'theme_color_darken' => ( function_exists('get_field') && get_field('pistacia_o_primary_darken_color','option') ) ? get_field('pistacia_o_primary_darken_color','option') : ''
) );

Pistacia_Bootstrap::get_instance();


// My codes

add_filter('acf/settings/show_admin', 'my_acf_show_admin');

function my_acf_show_admin( $show ) {
    
    return current_user_can('manage_options');
    
}

function wpdocs_excerpt_more( $more ) {
    return ' [mer]';
}
add_filter( 'excerpt_more', 'wpdocs_excerpt_more' );