<?php
/**
 * comments.php
 *
 * The template for displaying Comments.
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php
/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>

<?php if ( have_comments() ) : ?>

    <h3><?php esc_html_e('Comments','pistacia');?></h3>

    <ul class="comment-list">
        <?php wp_list_comments( array(
            'callback' => 'pistacia_comment',
            'reverse_top_level' => 1
        )); ?>
    </ul>

    <div class="text-center paginator-wrapper">
        <?php paginate_comments_links(); ?>
    </div>

<?php endif; ?>

<?php $comments_args = array(
    'label_submit' => esc_html__( 'Send', 'pistacia' ),
    'title_reply' => esc_html__( 'Write a Reply or Comment', 'pistacia' ),
    'comment_notes_after' => '',
);?>

<div class="comment-form">
    <?php comment_form( $comments_args ); ?>
</div>
