<?php
/**
 * pistacia_woocommerce.php
 *
 * This file Pistacia_Woocommerce class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

if ( !class_exists( 'Pistacia_Woocommerce' ) )
{
    class Pistacia_Woocommerce
    {
        private static $instance;

        protected function __construct()
        {

            if ( class_exists( 'WooCommerce' ) ) {

                define( 'WOOCOMMERCE_USE_CSS', false );

                /**
                 * Shop items per page setting 6
                 */
                $products_per_page = ( function_exists('get_field') && get_field('pistacia_o_shop_perpage','options') ) ? get_field('pistacia_o_shop_perpage','options') : 4 ;

                add_filter( 'loop_shop_per_page', create_function( '$cols', 'return ' . $products_per_page . ';' ), 20 );

                /**
                 * hook remove before shop loop catalog ordering and result count
                 */
                remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
                remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );

            }

            add_filter('add_to_cart_fragments', array($this,'pistacia_woocommerce_header_add_to_cart_fragment') );

        }


        static function the_cart(){?>

            <?php global $woocommerce; ?>

            <?php if ( $woocommerce ) : ?>

                <li>

                    <a href="<?php echo esc_url( $woocommerce->cart->get_cart_url() ); ?>" class="btn-shopping-cart">
                        <i class="fa fa-shopping-cart"></i>
                        <span class="cart-number cart-count"><?php echo esc_html($woocommerce->cart->cart_contents_count);?></span>
                    </a>

                </li>

            <?php endif; ?>

        <?php }


        static public function display_aside_products( $title = '', $box_style = 'light', $args = array() )
        {?>

            <?php if ( class_exists( 'WooCommerce' ) ) : ?>

            <?php $query = new WP_Query($args); ?>

            <?php if ( $query->have_posts() ) : ?>

                <div class="popular-widget clearfix <?php echo esc_html($box_style); ?>">

                    <?php if ( $title != '' ) : ?>
                        <h3 class="headline"><span><?php echo esc_html( $title ); ?></span></h3>
                    <?php endif; ?>

                    <?php while ( $query->have_posts() ) : $query->the_post(); ?>

                        <article class="item row">

                            <?php $img_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'thumbnail' ); ?>
                            <?php $img_big = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' ); ?>

                            <?php if ( !empty( $img_url ) ):?>
                                <div class="col-md-4">
                                    <a href="<?php the_permalink();?>">
                                        <figure class="figure-hubba">
                                            <img src="<?php echo esc_url($img_url[0]);?>" class="img-responsive wait-for-load" alt="">
                                            <figcaption class="figcaption">
                                                <span class="icon"><i class="fa fa-search"></i></span>
                                            </figcaption>
                                        </figure>
                                    </a>
                                </div>
                            <?php endif; ?>


                            <div class="col-md-<?php echo (!empty( $img_url ) ) ? '8' : '12'; ?>">

                                <h1><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>

                                <p><?php echo esc_html( substr( get_the_excerpt(), 0,60 ) ); ?>...</p>

                                <?php if ( class_exists( 'WooCommerce' ) ) : ?>
                                    <?php woocommerce_template_single_price(); ?>
                                <?php endif; ?>

                                <a href="<?php the_permalink();?>"><?php esc_html_e('more','pistacia');?></a>

                            </div>

                        </article>

                    <?php endwhile; ?>

                </div>

            <?php endif; ?>

        <?php endif; ?>

        <?php }


        static function the_categories_list()
        {
            $categories = get_categories( array(
                    'taxonomy' => 'product_cat',
                    'parent' => 0 )
            ); ?>

            <?php if ( !empty( $categories ) ) : ?>

            <ul class="collapse-menu">

                <?php foreach( $categories as $category ) : ?>

                    <?php $sub_categories = get_categories( array(
                        'taxonomy' => 'product_cat',
                        'parent' => $category->term_id )); ?>

                    <li class="active">

                        <a href="<?php echo esc_url( get_term_link($category->slug, 'product_cat') );?>">

                            <?php
                            $thumbnail_id = get_woocommerce_term_meta( $category->term_id, 'thumbnail_id', true );
                            $image = wp_get_attachment_url( $thumbnail_id );
                            if ( !empty( $image ) ) : ?>
                                <i><img src="<?php echo esc_url( $image ); ?>" class="img-responsive icon" alt=""></i>
                            <?php endif; ?>

                            <?php echo esc_html( $category->name ); ?>

                        </a>

                        <?php if ( !empty( $sub_categories ) ): ?>

                            <ul>

                                <?php foreach( $sub_categories as $sub_category ):?>
                                    <li class="">
                                        <a href="<?php echo esc_url( get_category_link( $sub_category->cat_ID ) );?>">

                                            <?php
                                            $thumbnail_id = get_woocommerce_term_meta( $sub_category->term_id, 'thumbnail_id', true );
                                            $image = wp_get_attachment_url( $thumbnail_id );

                                            if ( !empty( $image ) ) : ?>
                                                <i><img src="<?php echo esc_url( $image ); ?>" class="img-responsive icon" alt=""></i>
                                            <?php endif; ?>

                                            <?php echo esc_html( $sub_category->name ); ?>

                                        </a>
                                    </li>
                                <?php endforeach; ?>

                            </ul>

                        <?php endif; ?>

                    </li>

                <?php endforeach; ?>

            </ul>

        <?php endif; ?>
        <?php }


        /**
         * woocommerce_header_add_to_cart_fragment
         *
         * Ajax cart count in navigation
         *
         * @param $fragments
         * @return mixed
         */
        public function pistacia_woocommerce_header_add_to_cart_fragment( $fragments ) { ?>

            <?php global $woocommerce; ?>

            <?php if ( $woocommerce ) : ?>

                <?php ob_start(); ?>

                <span class="cart-count cart-number"><?php echo esc_html($woocommerce->cart->cart_contents_count); ?></span>

                <?php $fragments['span.cart-count.cart-number'] = ob_get_clean(); ?>

                <?php return $fragments; ?>

            <?php endif; ?>

        <?php }



        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

    }

}