<?php
/**
 * pistacia_widget_tags.php
 *
 * This file Pistacia_Widget_Tags class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.5.0
 */

if ( !class_exists('Pistacia_Widget_Tags') ) {

    class Pistacia_Widget_Tags extends WP_Widget
    {

        /**
         * Register widget with WordPress.
         */
        public function __construct()
        {
            parent::__construct(
                'pistacia_widget_tags',
                esc_html__('Pistacia Tags', 'pistacia'),
                array('description' => esc_html__('Display tags', 'pistacia'),)
            );
        }

        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args Widget arguments.
         * @param array $instance Saved values from database.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
            }

            pistacia_the_tags_widget( $title ='' , $box_style = 'light', array(
                'orderby' => ( !empty ($instance['orderby']) ) ? $instance['orderby'] : 'date',
                'order' => ( !empty ($instance['order']) ) ? $instance['order'] : 'DESC'
            ) );

            echo $args['after_widget'];

        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         */
        public function form( $instance )
        { ?>

            <?php $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Tags', 'pistacia'); ?>
            <?php $orderby = !empty($instance['orderby']) ? $instance['orderby'] : 'title' ; ?>
            <?php $order = !empty($instance['order']) ? $instance['order'] : 'DESC' ; ?>

            <p>
                <label
                    for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php echo esc_html__('Title','pistacia'); ?>:</label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>

            <p>
                <label for="<?php echo $this->get_field_id('orderby'); ?>"><?php echo esc_html__('Order by','pistacia'); ?>:
                    <select class='widefat' id="<?php echo $this->get_field_id('orderby'); ?>"
                            name="<?php echo $this->get_field_name('orderby'); ?>" type="text">
                        <option value='title'<?php echo ($orderby == 'title') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Title','pistacia'); ?>
                        </option>
                        <option value='date'<?php echo ($orderby == 'date') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Date','pistacia'); ?>
                        </option>
                        <option value='count'<?php echo ($orderby == 'count') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Counts','pistacia'); ?>
                        </option>
                    </select>
                </label>
            </p>

            <p>
                <label for="<?php echo $this->get_field_id('order'); ?>"><?php echo esc_html__('Order','pistacia'); ?>:
                    <select class='widefat' id="<?php echo $this->get_field_id('order'); ?>"
                            name="<?php echo $this->get_field_name('order'); ?>" type="text">
                        <option value='ASC'<?php echo ($order == 'ASC') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Ascendent','pistacia'); ?>
                        </option>
                        <option value='DESC'<?php echo ($order == 'DESC') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Descendant','pistacia'); ?>
                        </option>
                    </select>
                </label>
            </p>


        <?php }

        /**
         * Sanitize widget form values as they are saved.
         *
         * @see WP_Widget::update()
         *
         * @param array $new_instance Values just sent to be saved.
         * @param array $old_instance Previously saved values from database.
         *
         * @return array Updated safe values to be saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['orderby'] = (!empty($new_instance['orderby'])) ? strip_tags($new_instance['orderby']) : 'date';
            $instance['order'] = (!empty($new_instance['order'])) ? strip_tags($new_instance['order']) : 'DESC';
            return $instance;
        }

    }

}