<?php
/**
 * pistacia_widget_recentphotos.php
 *
 * This file Pistacia_Widget_Recentphotos class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.5.0
 */

if ( !class_exists('Pistacia_Widget_Recentphotos') ) {

    class Pistacia_Widget_Recentphotos extends WP_Widget
    {

        /**
         * Register widget with WordPress.
         */
        public function __construct()
        {
            parent::__construct(
                'pistacia_widget_recentphotos',
                esc_html__('Pistacia Recent Photos', 'pistacia'),
                array('description' => esc_html__('Display recent photos', 'pistacia'),)
            );
        }

        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args Widget arguments.
         * @param array $instance Saved values from database.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
            }

            pistacia_recent_images(
                $title = '',
                $box_style = '',
                array( 'posts_per_page' => (!empty($instance['posts_per_page'])) ? $instance['posts_per_page'] : 9 )
            );

            echo $args['after_widget'];
        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         */
        public function form($instance)
        {
            $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Recent photos', 'pistacia');
            $posts_per_page = !empty($instance['posts_per_page']) ? $instance['posts_per_page'] : 9 ; ?>

            <p>
                <label
                    for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php echo esc_html__('Title','pistacia'); ?>:</label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
                <label
                    for="<?php echo esc_attr($this->get_field_id('posts_per_page')); ?>"><?php echo esc_html__('How many photos','pistacia'); ?>:</label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('posts_per_page')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('posts_per_page')); ?>" type="number" min="1" step="1"
                       value="<?php echo esc_attr($posts_per_page); ?>">
            </p>

        <?php }

        /**
         * Sanitize widget form values as they are saved.
         *
         * @see WP_Widget::update()
         *
         * @param array $new_instance Values just sent to be saved.
         * @param array $old_instance Previously saved values from database.
         *
         * @return array Updated safe values to be saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['posts_per_page'] = (!empty($new_instance['posts_per_page'])) ? strip_tags($new_instance['posts_per_page']) : '';

            return $instance;
        }

    }

}