<?php
/**
 * pistacia_widget_menusaccordion.php
 *
 * This file Pistacia_Widget_Menusaccordion class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.5.7
 */

if ( !class_exists('Pistacia_Widget_Menusaccordion') ) {

    class Pistacia_Widget_Menusaccordion extends WP_Widget
    {

        /**
         * Register widget with WordPress.
         */
        public function __construct()
        {
            parent::__construct(
                'pistacia_widget_menusaccordion',
                esc_html__('Pistacia Menus Accordion', 'pistacia'),
                array('description' => esc_html__('Display menu accordion', 'pistacia'),)
            );
        }

        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args Widget arguments.
         * @param array $instance Saved values from database.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
            }?>

            <?php global $pistacia_menu_manager; ?>

            <?php $pistacia_menu_manager->the_menus_accordion( array(
            'text_color' => '',
            'item_order_by' => ( !empty($instance['order_by'])) ? $instance['order_by'] : 'title',
            'item_order' => ( !empty($instance['order'])) ? $instance['order'] : 'ASC',
            'photo_style' => ( !empty($instance['photo_style'])) ? $instance['photo_style'] : 'img-circle',
            'show_photo' => ( !empty($instance['show_photo']) && $instance['show_photo'] === '1') ? true : false,
            'show_count' => ( !empty($instance['show_count']) && $instance['show_count'] === '1') ? true : false, ) ); ?>

            <?php echo $args['after_widget'];

        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         */
        public function form( $instance )
        {?>
            <?php $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Menus', 'pistacia'); ?>
            <?php $orderby = !empty($instance['orderby']) ? $instance['orderby'] : 'title'; ?>
            <?php $order = !empty($instance['order']) ? $instance['order'] : 'ASC'; ?>
            <?php $show_count = !empty($instance['show_count']) ? $instance['show_count'] : false; ?>
            <?php $show_photo = !empty($instance['show_photo']) ? $instance['show_photo'] : false; ?>
            <?php $photo_style = !empty($instance['photo_style']) ? $instance['photo_style'] : 'img-circle'; ?>

            <p>
                <label
                    for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php echo esc_html__('Title','pistacia'); ?>:</label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>

            <p>
                <label for="<?php echo $this->get_field_id('orderby'); ?>"><?php echo esc_html__('Order by','pistacia'); ?>:
                    <select class='widefat' id="<?php echo $this->get_field_id('orderby'); ?>"
                            name="<?php echo $this->get_field_name('orderby'); ?>" type="text">
                        <option value='date'<?php echo ($orderby == 'date') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Date','pistacia'); ?>
                        </option>
                        <option value='title'<?php echo ($orderby == 'title') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Title','pistacia'); ?>
                        </option>
                        <option value='id'<?php echo ($orderby == 'id') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Id','pistacia'); ?>
                        </option>
                    </select>
                </label>
            </p>

            <p>
                <label for="<?php echo $this->get_field_id('order'); ?>"><?php echo esc_html__('Order','pistacia'); ?>:
                    <select class='widefat' id="<?php echo $this->get_field_id('order'); ?>"
                            name="<?php echo $this->get_field_name('order'); ?>" type="select">
                        <option value='ASC'<?php echo ($order == 'ASC') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Ascendent','pistacia'); ?>
                        </option>
                        <option value='DESC'<?php echo ($order == 'DESC') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Descendant','pistacia'); ?>
                        </option>
                    </select>
                </label>
            </p>

            <p>
                <label for="<?php echo $this->get_field_id('show_count'); ?>"><?php echo esc_html__('Show count','pistacia'); ?>:
                    <select class='widefat' id="<?php echo $this->get_field_id('show_count'); ?>"
                            name="<?php echo $this->get_field_name('show_count'); ?>" type="select">
                        <option value='1'<?php echo ($show_count == '1') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Show','pistacia'); ?>
                        </option>
                        <option value='0'<?php echo ($show_count == '0') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Hide','pistacia'); ?>
                        </option>
                    </select>
                </label>
            </p>

            <p>
                <label for="<?php echo $this->get_field_id('show_photo'); ?>"><?php echo esc_html__('Show photo','pistacia'); ?>:
                    <select class='widefat' id="<?php echo $this->get_field_id('show_photo'); ?>"
                            name="<?php echo $this->get_field_name('show_photo'); ?>" type="select">
                        <option value='1'<?php echo ($show_photo == '1') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Show','pistacia'); ?>
                        </option>
                        <option value='0'<?php echo ($show_photo == '0') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Hide','pistacia'); ?>
                        </option>
                    </select>
                </label>
            </p>

            <p>
                <label for="<?php echo $this->get_field_id('photo_style'); ?>"><?php echo esc_html__('Photo style','pistacia'); ?>:
                    <select class='widefat' id="<?php echo $this->get_field_id('photo_style'); ?>"
                            name="<?php echo $this->get_field_name('photo_style'); ?>" type="select">
                        <option value='img-circle'<?php echo ($photo_style == 'img-circle') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Circle','pistacia'); ?>
                        </option>
                        <option value='img-rounded'<?php echo ($photo_style == 'img-rounded') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Rounded','pistacia'); ?>
                        </option>
                        <option value='img-thumbnail'<?php echo ($photo_style == 'img-thumbnail') ? ' selected' : ''; ?>>
                            <?php echo esc_html__('Thumbnail','pistacia'); ?>
                        </option>
                    </select>
                </label>
            </p>

        <?php }

        /**
         * Sanitize widget form values as they are saved.
         *
         * @see WP_Widget::update()
         *
         * @param array $new_instance Values just sent to be saved.
         * @param array $old_instance Previously saved values from database.
         *
         * @return array Updated safe values to be saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
            $instance['orderby'] = (!empty($new_instance['orderby'])) ? strip_tags($new_instance['orderby']) : '';
            $instance['order'] = (!empty($new_instance['order'])) ? strip_tags($new_instance['order']) : '';
            $instance['show_count'] = (!empty($new_instance['show_count'])) ? strip_tags($new_instance['show_count']) : '';
            $instance['show_photo'] = (!empty($new_instance['show_photo'])) ? strip_tags($new_instance['show_photo']) : '';
            $instance['photo_style'] = (!empty($new_instance['photo_style'])) ? strip_tags($new_instance['photo_style']) : '';


            return $instance;
        }

    }

}