<?php
/**
 * pistacia_widget_categories.php
 *
 * This file Pistacia_Widget_Categories class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.5.0
 */

if ( !class_exists('Pistacia_Widget_Categories') ) {

    class Pistacia_Widget_Categories extends WP_Widget
    {

        /**
         * Register widget with WordPress.
         */
        public function __construct()
        {
            parent::__construct(
                'pistacia_widget_categories',
                esc_html__('Pistacia Categories', 'pistacia'),
                array('description' => esc_html__('Display categories menu', 'pistacia'),)
            );
        }

        /**
         * Front-end display of widget.
         *
         * @see WP_Widget::widget()
         *
         * @param array $args Widget arguments.
         * @param array $instance Saved values from database.
         */
        public function widget($args, $instance)
        {
            echo $args['before_widget'];

            if (!empty($instance['title'])) {
                echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
            }

            if( pistacia_has_categories() ): ?>
                <div class="nav-side-menu small light">
                    <?php pistacia_the_categories(); ?>
                </div>
            <?php endif; ?>

            <?php echo $args['after_widget'];

        }

        /**
         * Back-end widget form.
         *
         * @see WP_Widget::form()
         *
         */
        public function form( $instance )
        {?>
            <?php $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Categories', 'pistacia'); ?>

            <p>
                <label
                    for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php echo esc_html__('Title','pistacia'); ?>:</label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                       name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                       value="<?php echo esc_attr($title); ?>">
            </p>

        <?php }

        /**
         * Sanitize widget form values as they are saved.
         *
         * @see WP_Widget::update()
         *
         * @param array $new_instance Values just sent to be saved.
         * @param array $old_instance Previously saved values from database.
         *
         * @return array Updated safe values to be saved.
         */
        public function update($new_instance, $old_instance)
        {
            $instance = array();
            $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';

            return $instance;
        }

    }

}