<?php
/**
 * pistacia_visual_composer.php
 *
 * This file Pistacia_Visual_Composer class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

require_once( Pistacia_Helpers::get_template_directory() . '/visual_composer/js_composer_elements.php');

if ( !class_exists( 'Pistacia_Visual_Composer' ) )
{
    class Pistacia_Visual_Composer
    {
        private static $instance;

        protected function __construct()
        {

            add_action( 'vc_after_init', array($this,'pistacia_vc_remove_frontend_links') );
            add_action( 'vc_after_init', array($this,'pistacia_vc_remove_admin_bar_button') );
            add_action( 'vc_before_init', array($this,'pistacia_vcSetAsTheme') );
            add_action( 'vc_build_admin_page', array($this,'pistacia_vc_remove_woocommerce'), 11 );
            add_action( 'vc_load_shortcode', array($this,'pistacia_vc_remove_woocommerce'), 11 );

            /**
             * Remove default elements
             */
            if (function_exists('vc_remove_element')) {
                vc_remove_element( "vc_wp_search" );
                vc_remove_element( "vc_wp_meta" );
                //vc_remove_element( "vc_wp_recentcomments" );
                vc_remove_element( "vc_wp_calendar" );
                vc_remove_element( "vc_wp_pages" );
                vc_remove_element( "vc_wp_tagcloud" );
                vc_remove_element( "vc_wp_custommenu" );
                vc_remove_element( "vc_wp_text" );
                vc_remove_element( "vc_wp_posts" );
                //vc_remove_element( "vc_wp_categories" );
                vc_remove_element( "vc_wp_archives" );
                //vc_remove_element( "vc_wp_rss" );
            }

        }

        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        public function pistacia_vc_remove_woocommerce() {
            if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
                if ( function_exists('vc_remove_element')) {
                    vc_remove_element( 'woocommerce_cart' );
                    vc_remove_element( 'woocommerce_checkout' );
                    vc_remove_element( 'woocommerce_order_tracking' );
                    vc_remove_element( 'woocommerce_my_account' );
                    vc_remove_element( 'recent_products' );
                    vc_remove_element( 'featured_products' );
                    vc_remove_element( 'product' );
                    vc_remove_element( 'products' );
                    vc_remove_element( 'add_to_cart' );
                    vc_remove_element( 'add_to_cart_url' );
                    vc_remove_element( 'product_page' );
                    vc_remove_element( 'product_category' );
                    vc_remove_element( 'product_categories' );
                    vc_remove_element( 'sale_products' );
                    vc_remove_element( 'best_selling_products' );
                    vc_remove_element( 'top_rated_products' );
                    vc_remove_element( 'product_attribute' );
                    vc_remove_element( 'related_products' );
                }
            }
        }

        /**
         * Force Visual Composer to initialize as "built into the theme".
         * This will hide certain tabs under the Settings->Visual Composer page
         */
        public function pistacia_vcSetAsTheme() {
            vc_set_as_theme();
        }

        public function pistacia_vc_remove_admin_bar_button() {
            remove_action( 'admin_bar_menu', array( vc_frontend_editor(), 'adminBarEditLink' ), 1000 );
        }

        /**
         * Remove frontend editor
         */
        public function pistacia_vc_remove_frontend_links() {
            vc_disable_frontend();
        }


    }
}