<?php

if ( !class_exists('Pistacia_Theme_Color') )
{
    class Pistacia_Theme_Color
    {

        private static $instance;

        private $theme_color = '';
        private $theme_color_darken = '';

        protected function __construct()
        {

        }

        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        /**
         * Setting theme colors
         *
         * @param $args
         */
        public function set_colors( $args )
        {

            $this->theme_color = $args['theme_color'];
            $this->theme_color_darken = $args['theme_color_darken'];

            $this->wp_head_action_hook();

        }

        /**
         * Add css hook to header
         */
        public function wp_head_action_hook()
        {
            add_action('wp_head',array($this,'layout_theme_color_csshook') );
        }

        public static function color_brightness($hex, $percent) {

            $hash = '';
            if (stristr($hex,'#')) {
                $hex = str_replace('#','',$hex);
                $hash = '#';
            }
            $rgb = array(hexdec(substr($hex,0,2)), hexdec(substr($hex,2,2)), hexdec(substr($hex,4,2)));

            for ($i=0; $i<3; $i++) {

                if ($percent > 0) {
                    $rgb[$i] = round($rgb[$i] * $percent) + round(255 * (1-$percent));
                } else {
                    $positivePercent = $percent - ($percent*2);
                    $rgb[$i] = round($rgb[$i] * $positivePercent) + round(0 * (1-$positivePercent));
                }
                if ($rgb[$i] > 255) {
                    $rgb[$i] = 255;
                }
            }
            $hex = '';
            for($i=0; $i < 3; $i++) {
                $hexDigit = dechex($rgb[$i]);
                if(strlen($hexDigit) == 1) {
                    $hexDigit = "0" . $hexDigit;
                }
                $hex .= $hexDigit;
            }
            return $hash.$hex;
        }



        /**
         * Custom styles in header
         */
        public function layout_theme_color_csshook()
        { ?>

            <?php $theme_color = $this->theme_color; ?>

            <?php if ( !empty( $theme_color ) ) : ?>

            <?php $theme_color_darken = ( !empty( $this->theme_color_darken ) ) ? $this->theme_color_darken : $this->color_brightness( $theme_color, -0.95); ?>

            <?php $hex = str_replace( "#", "", $theme_color );
            if(strlen($hex) == 3) {
                $r = hexdec(substr($hex,0,1).substr($hex,0,1));
                $g = hexdec(substr($hex,1,1).substr($hex,1,1));
                $b = hexdec(substr($hex,2,1).substr($hex,2,1));
            } else {
                $r = hexdec(substr($hex,0,2));
                $g = hexdec(substr($hex,2,2));
                $b = hexdec(substr($hex,4,2));
            }
            $rgb = array($r, $g, $b); ?>

            <style>

                a,
                a:hover,
                a:active,
                a.add-to-favourite i,
                .comment-list .item .comment-rate span,
                .post-icons a.active,
                .nav-tabs > li.active > a,
                .nav-tabs > li.active > a:hover,
                .nav-tabs > li.active > a:focus,
                .pagination > li > a:hover,
                .pagination > li > span:hover,
                .pagination > li > a:focus,
                .pagination > li > span:focus,
                .pagination > li > span.current,
                #footer ul.contacts li .clock,
                #footer ul.contacts li a:hover,
                .product .photo .price ins span.amount,
                #bottomBar ul li a:hover,
                .interested-in-carousel .item .item-inner .price ins span.amount,
                ul.recipe-info-list li.difficulty i.active:before,
                .recipe-widget-box ul li .widget-text .difficulty i.active:before,
                .pistacia-aside .box .difficulty i:before,
                .woocommerce-product-rating .star-rating span:before,
                .star-rating span:before,
                .woo-tabs .wc-tab #reviews #comments ol.commentlist li .star-rating span:before,
                .woo-tabs .wc-tab #reviews #review_form_wrapper .comment-form-rating .stars a{
                    color:<?php echo esc_attr( $theme_color ); ?>;
                }

                .panel-default .panel-heading.active,
                .label-danger,
                .label-success,
                label.error,
                .btn-white:hover,
                .btn-white:active,
                .btn-white.active,
                .open > .dropdown-toggle.btn-white,
                .open > .dropdown-toggle.btn-primary,
                .primary-bg,
                .swiper-pagination-bullet-active,
                .popular-widget p.price ins span.amount,
                .noUi-connect,
                .nav-tabs li a::after,
                .quickcategories .nav-tabs,
                .quickcategories .nav-tabs > li > a,
                .list-toolbar .view-mode a.active,
                .datepicker-dark .ui-datepicker-prev:hover,
                .datepicker-dark .ui-datepicker-next:hover,
                .owl-theme .owl-controls .owl-nav [class*='owl-']:hover,
                .btn-shopping-cart .cart-number,
                .theme-switcher .inner ul.colors li a.color-green,
                .spinner-dot-in:before,
                .spinner-dot-stick:before,
                .spinner-double-dot-stick:before,
                .spinner-dot-out:before,
                .spinner-double-dot-out:before,
                .spinner-dot-in:after,
                .spinner-dot-stick:after,
                .spinner-double-dot-stick:after,
                .spinner-dot-out:after,
                .spinner-double-dot-out:after,
                .spinner-double-dot-in:before,
                .spinner-double-dot-in:after,
                .menucard-boxes .menucard-box:hover .btn-primary,
                .single-post .post-date,
                .timeline-badge.success,
                .isotope-grids a.btn-more,
                ul.list-tabs li.active a,
                .portfolio-items .item figure,
                .portfolio-items .item figure figcaption,
                .item .ribbon-primary,
                .comment-form form .form-submit input,
                .comment-respond form .form-submit input,
                .paginator-wrapper .page-numbers.current,
                #add_payment_method #payment div.payment_box,
                .woocommerce-checkout #payment div.payment_box,
                .woo-tabs .woocommerce-tabs ul.wc-tabs li.active a,
                .woo-tabs .wc-tab #reviews #review_form_wrapper .form-submit .submit,
                .interested-in-carousel .item .item-inner a.button,
                nav.woocommerce-pagination ul.page-numbers li .page-numbers.current,
                .shop-cart-section form .button,
                .shop-cart-section .cart-collaterals .cart_totals .checkout-button,
                .shop-cart-section .cart-collaterals .cart_totals .checkout-button:hover,
                .woocommerce form .button,
                .woocommerce form .button:hover,
                .woocommerce #respond input#submit,
                .woocommerce a.button,
                .woocommerce button.button,
                .woocommerce input.button,
                .woocommerce input.button.alt,
                .woocommerce button.button.alt,
                .wpcf7 form.wpcf7-form .wpcf7-form-control-wrap .wpcf7-not-valid-tip,
                .wpcf7 form.wpcf7-form .wpcf7-submit,
                .vc_tta-color-grey.vc-pistacia .vc_tta-tab.vc_active > a,
                .vc_tta-color-grey.vc-pistacia .vc_tta-panel.vc_active .vc_tta-panel-heading,
                .vc_tta-color-grey.vc-pistacia .vc_tta-tab.vc_active > a,
                .pistacia-recipes .recipe-section-inner .recipe-wrapper .recipe-ingredients-box,
                .recipe-box .recipe-box-inner .content ul.recipe-info-list:before,
                .recipe-widget-box h3.headline span:before,
                .pistacia-recipe-bar .pistacia-recipe-bar-container .pistacia-recipe-bar-inner #recipe-favourites-btn,
                .recipe-box .recipe-box-inner .photo .recipe-add-to-favourite.active,
                .recipes-slider-section .recipes-slider-section-inner .recipe-slider-wrapper .recipes-header-swiper-container .swiper-wrapper .swiper-slide .recipe-slide-wrapper .recipe-content,
                .logo-swiper-container .logo-swiper-button-next:hover, .logo-swiper-container .logo-swiper-button-prev:hover,
                .services-carousels-swiper-container .services_carousels-swiper-button-prev:hover,
                .services-carousels-swiper-container .services_carousels-swiper-button-next:hover,
                .pistacia-top-navigation .navbar-pistacia .container .btn-shopping-cart .cart-number,
                .modal-footer,
                .btn-primary,
                .btn-primary:focus,
                .btn-primary.focus,
                .btn-primary:hover,
                .btn-primary:active,
                .btn-primary.active,
                .btn-primary:active:focus,
                .btn-primary.disabled:hover,
                .btn-primary[disabled]:hover,
                fieldset[disabled] .btn-primary:hover,
                .btn-primary.disabled:focus,
                .btn-primary[disabled]:focus,
                fieldset[disabled] .btn-primary:focus,
                .btn-primary.disabled.focus,
                .btn-primary[disabled].focus,
                fieldset[disabled] .btn-primary.focus,
                .pistacia-top-navigation .navbar-pistacia .container .btn-shopping-cart .cart-number,
                .pistacia-top-navigation .navbar-pistacia .container-fluid .btn-shopping-cart .cart-number,
                .pistacia-top-navigation.light .navbar-pistacia .container-fluid #top-menu-collapse ul.top-menu > li.current-menu-ancestor > a:before,
                .pistacia-top-navigation.light .navbar-pistacia .container #top-menu-collapse ul.top-menu > li.current-menu-ancestor > a:before,
                .sticky-on #pistacia-top-navigation.pistacia-top-navigation.primary,
                .pistacia-top-navigation.primary,
                .food-menus-items ul.items > li .text-wrapper ul.featured li,
                .pistacia-aside .box form.woocommerce-product-search a.btn,
                .pistacia-aside .box ul.cart_list.product_list_widget li.mini_cart_item a.remove,
                .pistacia-aside .box form.search-form input.search-submit,
                .pistacia-aside .box .calendar_wrap table tr td a{
                    background-color:<?php echo esc_attr( $theme_color ); ?>;
                }

                .vc_btn3.vc_btn3-color-juicy-pink, .vc_btn3.vc_btn3-color-juicy-pink.vc_btn3-style-flat {
                    background-color: <?php echo esc_attr( $theme_color ); ?> !important;
                }

                .more-button-section a.btn.btn-append,
                .spinner-section:before,
                .spinner-section-in:before,
                .spinner-double-section-in:before,
                .spinner-section-out:before,
                .spinner-double-section-out:before,
                .spinner-section-far:before,
                .spinner-double-section-far:before,
                .spinner-section:after,
                .spinner-section-in:after,
                .spinner-double-section-in:after,
                .spinner-section-out:after,
                .spinner-double-section-out:after,
                .spinner-section-far:after,
                .spinner-double-section-far:after,
                .spinner-double-section:before,
                .spinner-double-section:after,
                .woocommerce .woocommerce-info,
                .woocommerce .woocommerce-error
                {
                    border-top-color:<?php echo esc_attr( $theme_color ); ?>;
                }

                .vc_tta-color-grey.vc-pistacia .vc_tta-tab > a
                {
                    border-bottom-color: <?php echo esc_attr( $theme_color ); ?>;
                }

                .quickcategories .tab-content:before

                {
                    border-color: transparent transparent transparent <?php echo esc_attr( $theme_color ); ?>;
                }

                .food-menus-items ul.items > li.active {
                    border-color: <?php echo esc_attr( $theme_color ); ?>;
                }

                @media (max-width: 991px){
                    .quickcategories .tab-content:before {
                        border-color: <?php echo esc_attr( $theme_color ); ?> transparent transparent transparent;
                    }
                }

                @media (min-width: 768px) {
                    .pistacia-top-navigation.primary {
                        background: <?php echo esc_attr( $theme_color ); ?>;
                    }
                }

                @media (max-width: 767px) {
                    .pistacia-top-navigation .navbar-pistacia .container #top-menu-collapse ul.top-menu,
                    .pistacia-top-navigation .navbar-pistacia .container-fluid #top-menu-collapse ul.top-menu {
                        background: <?php echo esc_attr( $theme_color ); ?>;
                    }
                }

                .btn-primary,
                .btn-primary:focus,
                .btn-primary.focus,
                #add_payment_method #payment div.payment_box:before,
                .woocommerce-checkout #payment div.payment_box:before,
                .vc_tta-color-grey.vc-pistacia .vc_tta-tab.vc_active > a,
                .vc_tta-color-grey.vc-pistacia .vc_tta-tab.vc_active > a
                {
                    border-color:<?php echo esc_attr( $theme_color ); ?>;
                }

                .nav-side-menu ul li ul
                {
                    border-left-color:<?php echo esc_attr( $theme_color ); ?>;
                }

                .ui-slider .ui-slider-range {
                    background: none repeat scroll 0 0 <?php echo esc_attr( $theme_color ); ?>;
                }

                @media (max-width: 991px) {
                    .quickcategories .tab-content:before {
                        border-color: <?php echo esc_attr( $theme_color ); ?> transparent transparent transparent;
                    }
                }

                @media (min-width: 768px){

                    .pistacia-top-navigation .navbar-pistacia .container #top-menu-collapse ul.top-menu li ul.sub-menu {
                        border-top-color:<?php echo esc_attr( $theme_color ); ?>;
                    }

                    .pistacia-top-navigation.light .navbar-pistacia .container #top-menu-collapse ul.top-menu > li.active > a:before,
                    .pistacia-top-navigation.light .navbar-pistacia .container #top-menu-collapse ul.top-menu > li.current-menu-ancestor > a:before{
                        background-color: <?php echo esc_attr( $theme_color ); ?>;
                    }

                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-90 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.9); }
                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-80 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.8); }
                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-70 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.7); }
                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-60 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.6); }
                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-50 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.5); }
                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-40 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.4); }
                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-30 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.3); }
                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-20 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.2); }
                    #pistacia-top-navigation.pistacia-top-navigation.primary.opacity-10 { background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.1); }

                    .sticky-on #pistacia-top-navigation.pistacia-top-navigation.primary {
                        background: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 1);
                    }

                    .pistacia-top-navigation .navbar-pistacia .container #top-menu-collapse ul.top-menu li.active > a,
                    .pistacia-top-navigation.light .navbar-pistacia .container #top-menu-collapse ul.top-menu li.current-menu-parent > a,
                    .pistacia-top-navigation.light .navbar-pistacia .container #top-menu-collapse ul.top-menu li.current-menu-ancestor > a,
                    .pistacia-top-navigation .navbar-pistacia .container #top-menu-collapse ul.top-menu li ul.sub-menu li.active > a,
                    .pistacia-top-navigation .navbar-pistacia .container #top-menu-collapse ul.top-menu li ul.sub-menu li.current-menu-ancestor > a,
                    .pistacia-top-navigation .navbar-pistacia .container #top-menu-collapse ul.top-menu li ul.sub-menu li a:hover,
                    .pistacia-top-navigation .navbar-pistacia .container-fluid #top-menu-collapse ul.top-menu li ul.sub-menu li.active > a,
                    .pistacia-top-navigation .navbar-pistacia .container-fluid #top-menu-collapse ul.top-menu li ul.sub-menu li.current-menu-ancestor > a,
                    .pistacia-top-navigation .navbar-pistacia .container-fluid #top-menu-collapse ul.top-menu li ul.sub-menu li a:hover,
                    .pistacia-top-navigation.primary .navbar-pistacia .container-fluid #top-menu-collapse #top-icons .btn-shopping-cart .cart-number,
                    .pistacia-top-navigation.primary .navbar-pistacia .container #top-menu-collapse #top-icons .btn-shopping-cart .cart-number,
                    .pistacia-top-navigation.light .navbar-pistacia .container-fluid #top-menu-collapse ul.top-menu li.current-menu-ancestor > a,
                    .pistacia-top-navigation.light .navbar-pistacia .container #top-menu-collapse ul.top-menu li.current-menu-ancestor > a{
                        color: <?php echo esc_attr( $theme_color ); ?>;
                    }
                }

                @media (min-width: 768px) {
                    .pistacia-top-navigation .navbar-pistacia .container #top-menu-collapse ul.top-menu li ul.sub-menu,
                    .pistacia-top-navigation .navbar-pistacia .container-fluid #top-menu-collapse ul.top-menu li ul.sub-menu {
                        border-top: 3px solid <?php echo esc_attr( $theme_color ); ?>;
                    }
                }

                .quote-carousel-section .overlay-black-70:after {
                    background-color: rgba(<?php echo esc_html($rgb[0]);?>, <?php echo esc_html($rgb[1]);?>, <?php echo esc_html($rgb[2]);?>, 0.8);
                }

                .isotope-grids a.btn-more:hover,
                .btn-white.hvr-shutter-out-horizontal:before,
                .btn-primary.hvr-shutter-out-horizontal:before,
                .shop-cart-section form .button:hover,
                .woocommerce #respond input#submit:hover,
                .woocommerce a.button:hover,
                .woocommerce button.button:hover,
                .woocommerce input.button:hover,
                .woocommerce input.button.alt:hover,
                .woocommerce button.button.alt:hover,
                .wpcf7 form.wpcf7-form .wpcf7-submit:hover,
                .quickcategories .nav-tabs > li.active > a,
                .quickcategories .nav-tabs > li.active > a:hover,
                .quickcategories .nav-tabs > li.active > a:focus,
                .quickcategories .nav > li > a:hover,
                .quickcategories .nav > li > a:focus,
                .modal-footer .btn-primary:hover
                {
                    background-color:<?php echo esc_attr( $theme_color_darken ); ?>;
                }

                .pistacia-aside .box ul li.cat-item ul {
                    border-left: 3px solid <?php echo esc_attr( $theme_color ); ?>;
                }

            </style>

        <?php endif; ?>

        <?php }
    }
}