<?php
/**
 * pistacia_tgm.php
 *
 * This file Pistacia_Tgm class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

require_once ( Pistacia_Helpers::get_template_directory() . '/class/tgm/tgm-plugin-activation.php' );

if ( !class_exists( 'Pistacia_Tgm' ) )
{
    class Pistacia_Tgm
    {

        private static $instance;

        protected function __construct()
        {
            $this->register_required_plugins();
        }

        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        private function register_required_plugins()
        {
            add_action( 'tgmpa_register', array($this,'_tgmpa_register') );
        }

        /**
         * Register the required plugins for this theme.
         *
         * In this example, we register five plugins:
         * - one included with the TGMPA library
         * - two from an external source, one from an arbitrary source, one from a GitHub repository
         * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
         *
         * The variable passed to tgmpa_register_plugins() should be an array of plugin
         * arrays.
         *
         * This function is hooked into tgmpa_init, which is fired within the
         * TGM_Plugin_Activation class constructor.
         */
        public function _tgmpa_register()
        {

            $plugins = array(
                array(
                    'name'               => 'ACF PRO',
                    'slug'               => 'advanced-custom-fields-pro',
                    'source'             => get_template_directory() . '/plugins/advanced-custom-fields-pro.zip',
                    'required'           => true,
                    'version'            => '',
                    'force_activation'   => true,
                    'force_deactivation' => true,
                    'external_url'       => '',
                    'is_callable'        => '',
                ),
                array(
                    'name'               => 'Woocommerce',
                    'slug'               => 'woocommerce',
                    'source'             => get_template_directory() . '/plugins/woocommerce.zip',
                    'required'           => false,
                    'version'            => '',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                    'is_callable'        => '',
                ),
                array(
                    'name'               => 'Pistacia Facebook Tags',
                    'slug'               => 'pistacia-facebook-tags',
                    'source'             => get_template_directory() . '/plugins/pistacia-facebook-tags.zip',
                    'required'           => true,
                    'version'            => '1.6.7',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                ),
                array(
                    'name'               => 'Pistacia Demo Importer',
                    'slug'               => 'pistacia-demo-importer',
                    'source'             => get_template_directory() . '/plugins/pistacia-demo-importer.zip',
                    'required'           => true,
                    'version'            => '1.6.7',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                ),
                array(
                    'name'               => 'Pistacia Recipe Manager',
                    'slug'               => 'pistacia-recipe-manager',
                    'source'             => get_template_directory() . '/plugins/pistacia-recipe-manager.zip',
                    'required'           => true,
                    'version'            => '1.6.7',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                ),
                array(
                    'name'               => 'Pistacia Gallery Manager',
                    'slug'               => 'pistacia-gallery-manager',
                    'source'             => get_template_directory() . '/plugins/pistacia-gallery-manager.zip',
                    'required'           => true,
                    'version'            => '1.6.7',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                ),
                array(
                    'name'               => 'Pistacia Menu Manager',
                    'slug'               => 'pistacia-menu-manager',
                    'source'             => get_template_directory() . '/plugins/pistacia-menu-manager.zip',
                    'required'           => true,
                    'version'            => '1.6.7',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                ),
                array(
                    'name'               => 'Slider Revolution',
                    'slug'               => 'revslider',
                    'source'             => get_template_directory() . '/plugins/revslider.zip',
                    'required'           => true,
                    'version'            => '',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                ),
                array(
                    'name'               => 'Contact Form 7',
                    'slug'               => 'contact-form-7',
                    'source'             => get_template_directory() . '/plugins/contact-form-7.zip',
                    'required'           => false,
                    'version'            => '',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                ),
                array(
                    'name'               => 'WPBakery Visual Composer',
                    'slug'               => 'js_composer',
                    'source'             => get_template_directory() . '/plugins/js_composer.zip',
                    'required'           => true,
                    'version'            => '',
                    'force_activation'   => false,
                    'force_deactivation' => false,
                    'external_url'       => '',
                )

            );

            /**
             * Array of configuration settings. Amend each line as needed.
             *
             * TGMPA will start providing localized text strings soon. If you already have translations of our standard
             * strings available, please help us make TGMPA even better by giving us access to these translations or by
             * sending in a pull-request with .po file(s) with the translations.
             *
             * Only uncomment the strings in the config array if you want to customize the strings.
             */
            $config = array(
                'id'           => 'tgmpa',
                'default_path' => '',
                'menu'         => 'tgmpa-install-plugins',
                'parent_slug'  => 'themes.php',
                'capability'   => 'edit_theme_options',
                'has_notices'  => true,
                'dismissable'  => true,
                'dismiss_msg'  => '',
                'is_automatic' => false,
                'message'      => '',
            );

            /**
             * Array of plugin arrays. Required keys are name and slug.
             * If the source is NOT from the .org repo, then source is also required.
             */


            tgmpa( $plugins, $config );

        }

    }
}