<?php
/**
 * icons.php
 *
 * Include FontAwesome and Flaticons
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

class Pistacia_Icons
{
    private static $instance;

    protected static $pistacia_awesome_icons;
    protected static $pistacia_flat_icons;
    protected static $pistacia_all_icons;

    public static function get_instance()
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }

        return static::$instance;
    }

    /**
     * @return array
     */
    public static function get_pistacia_all_icons()
    {
        return self::$pistacia_all_icons;
    }

    /**
     * PistaciaIcons constructor.
     */
    protected function __construct()
    {
        self::$pistacia_awesome_icons = $this->pistacia_get_fa_icons();
        self::$pistacia_flat_icons = $this->pistacia_get_flat_icons();
        self::$pistacia_all_icons = array_merge($this->pistacia_get_flat_icons(),$this->pistacia_get_fa_icons());
    }

    /**
     * @return array
     */
    private function pistacia_get_fa_icons()
    {

        require_once(ABSPATH .'/wp-admin/includes/file.php');

        WP_Filesystem();
        global $wp_filesystem;
        $icons = array();

        $pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s+{\s*content:\s*"(.+)";\s+}/';
        $file = get_template_directory().'/assets/css/font-awesome.css';

        if( $wp_filesystem->exists( $file ) ){
            $f = $wp_filesystem->get_contents( $file );
            preg_match_all($pattern, $f, $matches, PREG_SET_ORDER);
            foreach($matches as $match){
                $icons['fa '.$match[1]] = $match[1];
            }
        }

        return $icons;

    }

    public function vc_allicons()
    {}

    /**
     * @return array
     */
    private function pistacia_get_flat_icons()
    {
        return array(
            'flaticon-animal49'          => 'flaticon-animal49',
            'flaticon-apple55'           => 'flaticon-apple55',
            'flaticon-bakery20'          => 'flaticon-bakery20',
            'flaticon-basket37'          => 'flaticon-basket37',
            'flaticon-birthday10'        => 'flaticon-birthday10',
            'flaticon-birthday20'        => 'flaticon-birthday20',
            'flaticon-burger10'          => 'flaticon-burger10',
            'flaticon-carnivore'         => 'flaticon-carnivore',
            'flaticon-carrot8'           => 'flaticon-carrot8',
            'flaticon-cheese14'          => 'flaticon-cheese14',
            'flaticon-chilis'            => 'flaticon-chilis',
            'flaticon-cocktail32'        => 'flaticon-cocktail32',
            'flaticon-coffee50'          => 'flaticon-coffee50',
            'flaticon-coffeeshop141'     => 'flaticon-coffeeshop141',
            'flaticon-cook4'             => 'flaticon-cook4',
            'flaticon-covered16'         => 'flaticon-covered16',
            'flaticon-cutlery22'         => 'flaticon-cutlery22',
            'flaticon-cutlery23'         => 'flaticon-cutlery23',
            'flaticon-cutlery6'          => 'flaticon-cutlery6',
            'flaticon-dessert4'          => 'flaticon-dessert4',
            'flaticon-drink24'           => 'flaticon-drink24',
            'flaticon-drink81'           => 'flaticon-drink81',
            'flaticon-fast-food'         => 'flaticon-fast-food',
            'flaticon-fish52'            => 'flaticon-fish52',
            'flaticon-food20'            => 'flaticon-food20',
            'flaticon-fruit42'           => 'flaticon-fruit42',
            'flaticon-fruits1'           => 'flaticon-fruits1',
            'flaticon-healthy-food4'     => 'flaticon-healthy-food4',
            'flaticon-healthy-food5'     => 'flaticon-healthy-food5',
            'flaticon-heart340'          => 'flaticon-heart340',
            'flaticon-hot51'             => 'flaticon-hot51',
            'flaticon-ice53'             => 'flaticon-ice53',
            'flaticon-italian1'          => 'flaticon-italian1',
            'flaticon-lunch4'            => 'flaticon-lunch4',
            'flaticon-magnifying-glass32'=> 'flaticon-magnifying-glass32',
            'flaticon-magnifying-glass34'=> 'flaticon-magnifying-glass34',
            'flaticon-magnifying42'      => 'flaticon-magnifying42',
            'flaticon-meal2'             => 'flaticon-meal2',
            'flaticon-meat27'            => 'flaticon-meat27',
            'flaticon-organic22'         => 'flaticon-organic22',
            'flaticon-pizza10'           => 'flaticon-pizza10',
            'flaticon-pizza3'            => 'flaticon-pizza3',
            'flaticon-plate7'            => 'flaticon-plate7',
            'flaticon-pork'              => 'flaticon-pork',
            'flaticon-shopper43'         => 'flaticon-shopper43',
            'flaticon-shoppingbasket4'   => 'flaticon-shoppingbasket4',
            'flaticon-shoppingbasket5'   => 'flaticon-shoppingbasket5',
            'flaticon-steak'             => 'flaticon-steak',
            'flaticon-sugar10'           => 'flaticon-sugar10',
            'flaticon-sweet9'            => 'flaticon-sweet9',
            'flaticon-tea24'             => 'flaticon-tea24',
            'flaticon-tray32'            => 'flaticon-tray32',
            'flaticon-turkey7'           => 'flaticon-turkey7',
            'flaticon-turkey9'           => 'flaticon-turkey9',
            'flaticon-vegan'             => 'flaticon-vegan'
        );
    }

}
