<?php
/**
 * pistacia_helper.php
 *
 * This file Pistaci_Helper class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

require_once( get_template_directory() . '/functions/frontend.php');

if ( !class_exists('Pistacia_Helpers') )
{
    /**
     * Class Pistacia_Helpers
     */
    class Pistacia_Helpers
    {

        private static $instance;

        private static $theme_name = 'pistacia';

        /**
         * @var string
         */
        private static $theme_version = '1.6.7';

        /**
         * @var string
         */
        private static $template_directory = '';

        /**
         * @var string
         */
        private static $template_directory_uri = '';

        /**
         * Pistacia_Helpers constructor.
         */
        protected function __construct( )
        {
            self::$template_directory = get_template_directory();
            self::$template_directory_uri = get_template_directory_uri();

        }

        public static function get_instance()
        {
            if ( null === static::$instance ) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        /**
         * @param bool $display
         * @return string
         */
        public static function get_template_directory( $display = false )
        {
            if ( $display === true ) {
                echo self::$template_directory;
            } else {
                return self::$template_directory;
            }
        }

        /**
         * @param bool $display
         * @return string
         */
        public static function get_template_directory_uri( $display = false )
        {
            if ( $display === true ) {
                echo self::$template_directory_uri;
            } else {
                return self::$template_directory_uri;
            }
        }

        public static function get_theme_version( $display = false )
        {
            if ( $display === true ) {
                echo self::$theme_version;
            } else {
                return self::$theme_version;
            }
        }

        public static function get_theme_name( $display = false )
        {
            if ( $display === true ) {
                echo self::$theme_name;
            } else {
                return self::$theme_name;
            }
        }

        public function get_vc_shortcode_link($link){

            print $link;

            return $link;
        }

        /**
         * @param $content
         * @return array|null
         */
        public function get_shortcodes_array( $shortcode = '', $content ){

            if (!empty($content)) {

                $shortcodes = explode('][', $content);

                if (!empty($shortcodes) && count($shortcodes) > 0) {

                    $items = array();

                    foreach ($shortcodes as $sh) {

                        $find1 = array($shortcode . ' ', ']', '[');
                        $atts1 = str_replace($find1, '', $sh);

                        $find2 = array('" ');
                        $atts2 = str_replace($find2, '"+', $atts1);

                        $find3 = array('"');
                        $atts3 = str_replace($find3, '', $atts2);

                        $arr = explode('+', $atts3);
                        $brr = array();

                        if (!empty($arr)) {

                            foreach ($arr as $item) {

                                $a = explode('=', $item);

                                if (!empty($a)) {
                                    $brr[$a[0]] = $a[1];
                                }

                            }

                            array_push($items, $brr);

                        }
                    }

                    return $items;

                } else return null;

            }

        }

    }

} ?>