<?php
/**
 * pistacia_google_fonts.php
 *
 * This file Pistacia_Google_Fonts class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

if ( !class_exists( 'Pistacia_Google_Fonts' ) )
{
    class Pistacia_Google_Fonts
    {

        private static $instance;

        private $google_fonts_url = '';

        private $google_fonts = array();

        private $theme_body_font_color ='';

        /* default theme font */
        private $theme_fonts = array(
            'primary' => array(
                'id' => 'merriweather',
                'name' => 'Merriweather',
                'font_family' => 'Merriweather:400,700,400italic'
            ),
            'secondary' => array(
                'id' => 'raleway',
                'name' => 'Raleway',
                'font_family' => 'Raleway:400,700'
            ) );

        protected function __construct()
        {
            $this->set_google_fonts();
        }

        private function set_google_fonts()
        {
            $google_fonts = array(

                'primary' => array(

                    'merriweather' => array(
                        'id' => 'merriweather',
                        'name' => 'Merriweather',
                        'font_family' => 'Merriweather:400,700,400italic'
                    ),

                    'raleway' => array(
                        'id' => 'raleway',
                        'name' => 'Raleway',
                        'font_family' => 'Raleway:400,700'
                    ),

                    'ptsans' => array(
                        'id' => 'ptsans',
                        'name' => 'PT Sans',
                        'font_family' => 'PT Sans:400,400italic,700,700italic'
                    ),

                    'robotoslab' => array(
                        'id' => 'robotoslab',
                        'name' => 'Roboto Slab',
                        'font_family' => 'Roboto Slab:400,700'
                    ),

                    'droidsans' => array(
                        'id' => 'droidsans',
                        'name' => 'Droid Sans',
                        'font_family' => 'Droid Sans:400,700'
                    ),

                    'exo' => array(
                        'id' => 'exo',
                        'name' => 'Exo',
                        'font_family' => 'Exo:400,400italic,700,700italic'
                    ),

                    'nunito' => array(
                        'id' => 'nunito',
                        'name' => 'Nunito',
                        'font_family' => 'Nunito:400,700'
                    ),

                    'alegreyasans' => array(
                        'id' => 'alegreyasans',
                        'name' => 'Alegreya Sans',
                        'font_family' => 'Alegreya Sans:400,400italic,700,700italic'
                    ),

                    'titilliumweb' => array(
                        'id' => 'titilliumweb',
                        'name' => 'Titillium Web',
                        'font_family' => 'Titillium Web:400,400italic,700,700italic'
                    ),

                    'lora' => array(
                        'id' => 'lora',
                        'name' => 'Lora',
                        'font_family' => 'Lora:400,400italic,700,700italic'
                    ),

                ),

                'secondary' => array(

                    'merriweather' => array(
                        'id' => 'merriweather',
                        'name' => 'Merriweather',
                        'font_family' => 'Merriweather:400,700,400italic'
                    ),

                    'raleway' => array(
                        'id' => 'raleway',
                        'name' => 'Raleway',
                        'font_family' => 'Raleway:400,700'
                    ),

                    'ptsans' => array(
                        'id' => 'ptsans',
                        'name' => 'PT Sans',
                        'font_family' => 'PT Sans:400,400italic,700,700italic'
                    ),

                    'robotoslab' => array(
                        'id' => 'robotoslab',
                        'name' => 'Roboto Slab',
                        'font_family' => 'Roboto Slab:400,700'
                    ),

                    'droidsans' => array(
                        'id' => 'droidsans',
                        'name' => 'Droid Sans',
                        'font_family' => 'Droid Sans:400,700'
                    ),

                    'exo' => array(
                        'id' => 'exo',
                        'name' => 'Exo',
                        'font_family' => 'Exo:400,400italic,700,700italic'
                    ),

                    'nunito' => array(
                        'id' => 'nunito',
                        'name' => 'Nunito',
                        'font_family' => 'Nunito:400,700'
                    ),

                    'alegreyasans' => array(
                        'id' => 'alegreyasans',
                        'name' => 'Alegreya Sans',
                        'font_family' => 'Alegreya Sans:400,400italic,700,700italic'
                    ),

                    'titilliumweb' => array(
                        'id' => 'titilliumweb',
                        'name' => 'Titillium Web',
                        'font_family' => 'Titillium Web:400,400italic,700,700italic'
                    ),

                    'lora' => array(
                        'id' => 'lora',
                        'name' => 'Lora',
                        'font_family' => 'Lora:400,400italic,700,700italic'
                    ),

                )

            );

            $this->google_fonts = $google_fonts;

        }


        public function get_google_fonts_choices( $args )
        {

            $google_fonts = array();

            if (array_key_exists($args, $this->google_fonts )) {
                foreach ($this->google_fonts[$args] as $item) {
                    $google_fonts[ $item['id'] ] = $item['name'];
                }
            }

            return $google_fonts;

        }



        public function run()
        {

            if ( function_exists('get_field') ) {

                $primary_font = get_field('pistacia_o_primary_font','option');
                $secondary_font = get_field('pistacia_o_secondary_font','option');
                $body_font_color = get_field('pistacia_o_body_font_color','option');

                if ( $body_font_color ) {

                    $this->theme_body_font_color = $body_font_color;
                    $this->add_font_color_wp_head_hook();

                }

                if ( $primary_font && $secondary_font ) {

                    $args = array();

                    if ( $primary_font != 'default' ){
                        $args['primary'] = $this->google_fonts['primary'][$primary_font];

                    } else {
                        $args['primary'] = $this->theme_fonts['primary'];
                    }

                    if ( $secondary_font != 'default' ){
                        $args['secondary'] = $this->google_fonts['secondary'][$secondary_font];
                    } else {
                        $args['secondary'] = $this->theme_fonts['secondary'];
                    }

                    if ( $primary_font != 'default' || $secondary_font != 'default' ) {
                        $this->set_fonts( $args );
                        $this->add_font_wp_head_hook();
                    } else {
                        $this->set_fonts( $this->theme_fonts );
                    }

                } else {
                    $this->set_fonts( $this->theme_fonts );
                }

            } else {
                $this->set_fonts( $this->theme_fonts );
            }

        }

        public function add_font_color_wp_head_hook()
        {
            add_action('wp_head',array($this,'layout_theme_font_color_hook') );
        }

        public function layout_theme_font_color_hook()
        { ?>

            <?php $body_font_color = $this->theme_body_font_color; ?>

            <style>
                body, h1, h2, h3, h4, h5,
                .panel-default > .panel-heading,
                .panel-default .panel-title a,
                .panel-default .panel-title :hover,
                .panel-default .panel-title :focus,
                .btn-default,
                select.form-control,
                .popular-widget h1 a,
                .post-icons a,
                ul.tags li a ,
                .pagination > li > a,
                .pagination > li > span,
                .nav-side-menu ul li a,
                .datepicker-light .ui-datepicker-title,
                .datepicker-light .ui-datepicker-calendar a,
                .socialbar.light a.socicon,
                .recipes-slider-section .recipes-slider-section-inner .recipe-slider-wrapper .recipes-header-swiper-container .swiper-wrapper .swiper-slide .recipe-slide-wrapper .recipe-content .recipe-content-inner .btn-more,
                .recipe-box .recipe-box-inner .content h1.title a,
                #reservation.light h1,
                .list-toolbar select,
                #reservation.light input.form-control,
                #reservation.light textarea.form-control,
                #reservation.light select.form-control,
                .menucard-boxes .menucard-box .container-inner .item-detail,
                .menucard-boxes .menucard-box .container-inner h4 a,
                ul.comment-list li .inner .info .comment-name,
                ul.comment-list li .inner .info .date,
                ul.comment-list li .inner .info .comment-text,
                ul.comment-list li .inner .info a.button,
                .single-post .post-lead,
                .single-post .post-title h3 a,
                .isotope-grids .element-item .inner .post-article .post-header h1 a,
                .product h2 a,
                #bottomBar ul li a,
                .woo-tabs .woocommerce-tabs ul.wc-tabs li a,
                .woocommerce #reviews #comments ol.commentlist li .meta,
                .interested-in-carousel .item .item-inner .price del span.amount,
                nav.woocommerce-pagination ul.page-numbers li .page-numbers
                {
                    color:<?php echo esc_html( $body_font_color ); ?>;
                }
                @media (min-width: 768px) {
                    #pistacia-top-navigation .navbar-default .container #top-menu-collapse ul.top-menu li a {
                        color:<?php echo esc_html( $body_font_color ); ?>;
                    }
                }
            </style>

        <?php }

        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        public function layout_theme_font_hook()
        { ?>

            <?php $body_font = $this->theme_fonts['primary']['name']; ?>
            <?php $title_font = $this->theme_fonts['secondary']['name']; ?>

            <style>
                body,
                #pistacia-top-navigation .navbar-default .container #top-menu-collapse ul.top-menu li ul.sub-menu li a {
                    font-family: <?php echo $body_font; ?>, sans-serif;
                }

                h1,
                h2,
                h3,
                h4,
                h5,
                #pistacia-top-navigation .navbar-default .container #top-menu-collapse ul.top-menu li a,
                .recipe-widget-box ul li .widget-text a.title,
                .text-slider li,
                #bottomBar ul li a{
                    font-family: <?php echo $title_font; ?>, sans-serif;
                }
            </style>

        <?php }


        /**
         * Must only 2 fonts in array
         * first font the body font and second font is title font
         * @param array $theme_fonts
         */
        public function set_fonts( $theme_fonts = array() )
        {

            if ( count( $theme_fonts ) == 2 ) {

                $query_args = array(
                    'family' => urlencode( $theme_fonts['primary']['font_family'] . '|' . $theme_fonts['secondary']['font_family'] ),
                    'subset' => urlencode('latin,latin-ext'),
                );

                $this->theme_fonts['primary'] = $theme_fonts['primary'];
                $this->theme_fonts['secondary'] = $theme_fonts['secondary'];

                $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
                $this->google_fonts_url = esc_url_raw($fonts_url);
                add_action('wp_enqueue_scripts', array($this, 'google_fonts_scripts_styles'));

            }

        }

        public function add_font_wp_head_hook(){
            add_action('wp_head',array($this,'layout_theme_font_hook') );
        }

        public function google_fonts_scripts_styles()
        {
            wp_enqueue_style( 'pistacia-fonts', $this->google_fonts_url, array(), null );
        }

    }

}