<?php
/**
 * pistacia_customize.php
 *
 * This file Pistacia_Customize class
 * Brand logo
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

if ( !class_exists( 'Pistacia_Cutomize' ) )
{
    class Pistacia_Customize
    {
        private static $instance;

        protected function __construct()
        {

            add_action( 'customize_register', array($this,'customize_brandlogo') );

        }

        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        /**********************************************************************************************************************
         *
         * Brand logo customize upload
         *
         **********************************************************************************************************************/

        /**
         * pistacia_customize_brandlogo
         *
         * @param $wp_customize
         */
        public function customize_brandlogo( $wp_customize ) {

            /* brand logo */
            $wp_customize->add_setting('ps_theme_brandlogo', array(
                'default' => '',
                'sanitize_callback' => 'esc_html'
            ));

            $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'ps_theme_brandlogo', array(
                'label'    => esc_html__( 'Logo', 'pistacia' ),
                'section'  => 'pistacia_brandlogo',
                'settings' => 'ps_theme_brandlogo',
            ) ) );

            $wp_customize->add_section('pistacia_brandlogo' , array(
                'title' => esc_html__('Brand logo','pistacia'),
                'default' => '',
                'sanitize_callback' => 'esc_url',
                'type' => 'option',
                'capability' => 'edit_theme_options',
                'transport' => 'refresh',
            ));

        }

    }

}