<?php
/**
 * pistacia_bootstrap.php
 *
 * This file Pistacia_Bootstrap class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

if ( !class_exists( 'Pistacia_Bootstrap' ) )
{
    class Pistacia_Bootstrap
    {

        private static $instance;

        /**
         * Pistacia_Bootstrap constructor.
         */
        protected function __construct()
        {

            add_action( 'after_setup_theme', array($this,'setup_theme') );
            add_action( 'admin_enqueue_scripts', array($this,'load_admin_styles') );
            add_action( 'wp_head', array( $this,'layout_background_color_csshook' ) );

            if ( !is_admin() ) {
                add_action( 'wp_enqueue_scripts', array($this,'theme_enqueue_scripts_styles') );
            }

            if ( ! function_exists( '_wp_render_title_tag' ) ) {
                add_action( 'wp_head', array( $this,'theme_slug_render_title' ) );
            }

            if ( is_admin() ) {
                add_action( 'do_meta_boxes', array( $this,'remove_revolution_slider_meta_boxes' ) );
            }

            add_action( 'widgets_init', array($this,'pistacia_widgets_init') );

        }


        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

        function pistacia_widgets_init() {

            register_sidebar( array(
                'name'          => 'Post single sidebar',
                'id'            => 'pistacia_single_sb',
                'before_widget' => '<div class="box">',
                'after_widget'  => '</div>',
                'before_title'  => '<h3 class="headline"><span>',
                'after_title'   => '</span></h3>',
            ) );

            register_sidebar( array(
                'name'          => 'Blog sidebar',
                'id'            => 'pistacia_blog_sb',
                'before_widget' => '<div class="box">',
                'after_widget'  => '</div>',
                'before_title'  => '<h3 class="headline"><span>',
                'after_title'   => '</span></h3>',
            ) );

            register_sidebar( array(
                'name'          => 'Page sidebar',
                'id'            => 'pistacia_page_sb',
                'before_widget' => '<div class="box">',
                'after_widget'  => '</div>',
                'before_title'  => '<h3 class="headline"><span>',
                'after_title'   => '</span></h3>',
            ) );

            register_sidebar( array(
                'name'          => 'Footer widgets',
                'id'            => 'pistacia_footer_widgets',
                'before_widget' => '<div class="footer-widget-box">',
                'after_widget'  => '</div>',
                'before_title'  => '<h2 class="title"><span>',
                'after_title'   => '</span></h2>',
            ) );

            register_widget( 'Pistacia_Widget_Recentphotos' );
            register_widget( 'Pistacia_Widget_Recentposts' );
            register_widget( 'Pistacia_Widget_Tags' );
            register_widget( 'Pistacia_Widget_Categories' );

            if ( function_exists('get_field') ){
                register_widget( 'Pistacia_Widget_Menusaccordion' );
                register_widget( 'Pistacia_Widget_Footertext' );
                register_widget( 'Pistacia_Widget_Testimonyslider' );
                register_widget( 'Pistacia_Widget_Operationtime' );
                register_widget( 'Pistacia_Widget_Contact' );
            }

            if (class_exists( 'WooCommerce' )) {
                register_sidebar( array(
                    'name'          => 'Shop products sidebar',
                    'id'            => 'pistacia_products_sb',
                    'before_widget' => '<div class="box">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<h3 class="headline"><span>',
                    'after_title'   => '</span></h3>',
                ) );
                register_widget('Pistacia_Widget_Recentproducts');
                register_widget('Pistacia_Widget_Productcategories');
            }

            if (class_exists( 'Pistacia_Recipe_Manager' )) {
                register_widget('Pistacia_Widget_Recentrecipes');
            }

        }


        /**
         * theme_slug_render_title
         * Since Version 4.1, themes should use add_theme_support() in the functions.php file in order to support title tag
         * this function backwards compatibility for older versions
         */
        public function theme_slug_render_title()
        { ?>
            <title><?php wp_title( '|', true, 'right' ); ?></title>
        <?php }


        /**
         * Add scripts and styles
         */
        public function theme_enqueue_scripts_styles()
        {
            if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ){
                wp_enqueue_script( 'comment-reply' );
            }

            // Vendors
            wp_enqueue_script(
                'pistacia-vendors-js',
                esc_url( Pistacia_Helpers::get_template_directory_uri() ).'/assets/js/pistacia-vendors.min.js',
                array('jquery'),
                Pistacia_Helpers::get_theme_version(),
                true
            );

            wp_enqueue_style(
                'pistacia-vendors',
                esc_url( Pistacia_Helpers::get_template_directory_uri() ).'/assets/css/pistacia-vendors.min.css',
                array(),
                Pistacia_Helpers::get_theme_version(),
                'all'
            );

            // Styles
            wp_enqueue_style(
                'style',
                esc_url( get_stylesheet_uri() ),
                array(),
                Pistacia_Helpers::get_theme_version(),
                'all'
            );

            // Layout styles
            wp_enqueue_style(
                'pistacia-style-layout',
                esc_url( Pistacia_Helpers::get_template_directory_uri() ).'/assets/css/pistacia-style.min.css',
                array(),
                Pistacia_Helpers::get_theme_version(),
                'all'
            );

            // application
            wp_enqueue_script(
                'pistacia-application-js',
                esc_url( Pistacia_Helpers::get_template_directory_uri() ).'/assets/js/pistacia-application.min.js',
                array('jquery'),
                Pistacia_Helpers::get_theme_version(),
                true
            );

            wp_localize_script(
                'pistacia-application-js',
                'pistacia_application_localize',
                array(
                    'stylesheet_directory' => esc_url( Pistacia_Helpers::get_template_directory_uri() ),
                    'ajax_url' => esc_url( admin_url( 'admin-ajax.php' ) ),
                    'form_error' => esc_html__( 'Form error. Please contact administrator.', 'pistacia' ),
                    'form_success' => esc_html__('Form success. Sent email', 'pistacia' ),
                    'validator_required_element' => esc_html__('Required element', 'pistacia' ),
                    'validator_does_not_email' => esc_html__('It doesen\'t email format', 'pistacia' ),
                    'validator_does_not_number' => esc_html__('It doesen\'t number format', 'pistacia' )
                ));
        }


        /**
         * echo body background color from get_them_mod
         */
        public function layout_background_color_csshook()
        {
            if( function_exists('get_field') && get_field('pistacia_o_bg_color','option') ) : ?>
                <style>
                    body{
                        background-color:<?php echo esc_html(get_field('pistacia_o_bg_color','option'));?> !important;
                    }
                </style>
            <?php endif; ?>
        <?php }


        /**
         * Setup theme
         */
        public function setup_theme()
        {
            if ( ! isset( $content_width ) ) {
                $content_width = 1200;
            }

            load_theme_textdomain( 'pistacia', Pistacia_Helpers::get_template_directory() . '/lang');

            add_theme_support( 'automatic-feed-links' );
            add_theme_support( 'post-thumbnails');
            add_theme_support( 'title-tag' );
            add_theme_support( 'woocommerce' );
            add_theme_support( 'post-formats', array( 'video','image' ) );

            add_filter( 'body_class', array($this,'body_class') );

            register_nav_menus( array(
                'top-menu' => esc_html__( 'Top Menu', 'pistacia' ),
                'footer-menu' => esc_html__( 'Footer Menu', 'pistacia' )
            ));

            add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );

            add_theme_support( 'custom-header', array(
                'width' => 2560,
                'height' => 1707,
                'header-text' => false,
                'default-image' => Pistacia_Helpers::get_template_directory_uri() . '/assets/img/custom_header.jpg',
            ));

        }

        /**
         * @param $classes
         * @return array
         */
        public function body_class( $classes )
        {
            global $post;

            $boxed_class = 'ps-wide';
            $navigation_class = 'fixed-navigation';

            if ( ( function_exists('get_field') && get_field('pistacia_o_theme_setup_boxed','option') && get_field('pistacia_o_theme_setup_boxed','option') == 'boxed' ) ){
                $boxed_class = 'ps-boxed';
            }

            if ( ( function_exists('get_field') && get_field('pistacia_o_theme_setup_fixednavigation','option') && get_field('pistacia_o_theme_setup_fixednavigation','option') == 'off' ) ){
                $navigation_class = '';
            }

            if ( isset( $post ) ) {
                $classes[] = esc_attr( $post->post_type . '_' . $post->post_name );
            }

            if (is_single() ) {
                foreach((wp_get_post_terms( $post->ID)) as $term) {
                    $classes[] = esc_attr( $term->slug );
                }
                foreach((wp_get_post_categories( $post->ID, array('fields' => 'slugs'))) as $category) {

                    $classes[] = esc_attr( $category );
                }
            }

            $classes[] = esc_attr( 'pistacia' );

            $classes[] = esc_attr($boxed_class);
            $classes[] = esc_attr($navigation_class);

            return $classes;
        }


        /**
         * Remove revolution slider meta box
         */
        public function remove_revolution_slider_meta_boxes()
        {
            remove_meta_box( 'mymetabox_revslider_0', 'page', 'normal' );
            remove_meta_box( 'mymetabox_revslider_0', 'post', 'normal' );
            remove_meta_box( 'mymetabox_revslider_0', 'gallery', 'normal' );
        }


        /**
         * Admin css loading
         */
        public function load_admin_styles()
        {
            wp_enqueue_style(
                'admin_css',
                esc_url( Pistacia_Helpers::get_template_directory_uri() ).'/admin-style.css',
                array(),Pistacia_Helpers::get_theme_version(),'all'
            );
        }

    }

}