<?php
/**
 * pistacia_ajax_forms.php
 *
 * This file Pistacia_Ajax_Forms class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

if ( !class_exists( 'Pistacia_Ajax_Forms' ) )
{
    class Pistacia_Ajax_Forms
    {
        private static $instance;

        protected function __construct()
        {
            $this->add_actions();
        }

        private function add_actions()
        {
            
            add_action( 'wp_ajax_pistacia_ajaxcontact_send_mail', array($this,'pistacia_ajaxcontact_send_mail') );
            add_action( 'wp_ajax_nopriv_pistacia_ajaxcontact_send_mail', array($this,'pistacia_ajaxcontact_send_mail') );

            add_action( 'wp_ajax_pistacia_ajaxreservation_send_mail', array($this,'pistacia_ajaxreservation_send_mail') );
            add_action( 'wp_ajax_nopriv_pistacia_ajaxreservation_send_mail', array($this,'pistacia_ajaxreservation_send_mail') );

        }

        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }


        /**
         * ajaxreservation_send_mail
         *
         * Send email with wp_mail funtion to admin email
         *
         */
        function pistacia_ajaxreservation_send_mail() {

            Pistacia_Email::get_instance();

            $data = array(
                'first_name' => sanitize_text_field($_POST['reservation_first_name']),
                'last_name' => sanitize_text_field($_POST['reservation_last_name']),
                'date' => sanitize_text_field($_POST['reservation_date']),
                'time' => sanitize_text_field($_POST['reservation_time']),
                'numberof' => sanitize_text_field($_POST['reservation_guest_number']),
                'phone' => sanitize_text_field($_POST['reservation_phone']),
                'email' => sanitize_email($_POST['reservation_email']),
                'message' => sanitize_text_field($_POST['reservation_message'])
            );

            $subject = get_option('blogname').' '. esc_html__(' reservation form','pistacia');

            $to = get_option('admin_email');

            $message = '<b>'.esc_html__('From','pistacia').': </b>'.esc_html($data['first_name']).' ' . $data['last_name'] . "<br>";

            $message .= '<b>'.esc_html__('E-mail','pistacia').':</b>' . $data['email'] . "<br>";

            $message .= '<b>'.esc_html__('Phone','pistacia').':</b> ' . $data['phone'] . "<br>";

            $message .= '<b>'.esc_html__('Number','pistacia').':</b> '. $data['numberof'] . "<br>";

            $message .= '<b>'.esc_html__('Date','pistacia').':</b> '. $data['date'] . " - ". $data['time'] . "<br>";

            $message .= '<b>'.esc_html__('Specials','pistacia').':</b> '."<br>" . $data['message'];

            $html = Pistacia_Email::email_template( esc_html__('Reservation form','pistacia' ),$message);

            $headers[] = 'From: <' . $data["email"] . '>';

            $headers[] = 'Content-Type: text/html; charset=UTF-8';

            wp_mail( $to, $subject, $html, $headers );

        }


        /**
         * ajaxcontact_send_mail
         *
         * Send email with wp_mail funtion to admin email
         *
         */
        function pistacia_ajaxcontact_send_mail() {

            Pistacia_Email::get_instance();

            $data = array(
                'name' => sanitize_text_field($_POST['contact_name']),
                'email' => sanitize_email($_POST['contact_email']),
                'message' => sanitize_text_field($_POST['contact_message'])
            );

            $subject = get_option('blogname') . ' ' . esc_html__('contact form','pistacia');

            $to = get_option('admin_email');

            $message = '<b>'.esc_html__('From','pistacia').':</b> ' . $data['name'] . "<br>";

            $message .= '<b>'.esc_html__('E-mail','pistacia').':</b> ' . $data['email'] . "<br>";

            $message .= '<b>'.esc_html__('Message','pistacia').':</b> '."<br>" . $data['message'];

            $html = Pistacia_Email::email_template( esc_html__('Contact form','pistacia') , $message );

            $headers[] = 'From: <' . $data["email"] . '>';

            $headers[] = 'Content-Type: text/html; charset=UTF-8';

            wp_mail( $to, $subject, $html, $headers );

        }

        static function the_contact_form(){?>

            <form name="contactForm" id="cntForm" method="post">

                <input type="text" name="cntCode" id="cntCode" class="form-control hidden" placeholder="" value="">

                <div class="row">
                    <div class="col-xs-6">
                        <input type="text" name="contact_name" class="form-control" placeholder="<?php esc_html_e('Name','pistacia');?> *" required="">
                    </div>
                    <div class="col-xs-6">
                        <input type="text" name="contact_email" id="email" class="form-control" placeholder="<?php esc_html_e('E-mail','pistacia');?> *" required="">
                    </div>
                </div>

                <div class="row">
                    <div class="col-xs-12">
                        <textarea name="contact_message" class="form-control contact-message" rows="3"></textarea>
                    </div>
                </div>

                <a class="btn btn-primary hvr-shutter-out-horizontal btn-send" href="#"><?php esc_html_e('Send contact','pistacia');?></a>

            </form>

        <?php }


        /**
         * the_reservation_form
         *
         * Display reservation form in frontend
         * @param array $param
         */
        static function the_reservation_form($param = array( 'calendar_hide' => false, 'reservation_times' => '' )){?>

            <?php $columns = ( !$param['calendar_hide']) ? '6' : '12';?>
            <form class="reservation_form" name="reservationForm" method="POST" id="reservation_form-<?php echo md5(rand(0,1024).time());?>">
                <div class="reservation-inner">
                    <div class="collapse in" id="reservationForm">
                        <div class="clearfix">
                            <div class="col-md-<?php echo esc_attr($columns);?> fadeInLeft-ifAppeared">
                                <h1><span class="light"><?php esc_html_e( 'Bokningsförfrågan','pistacia' );?></span> <span class="extra-bold"><?php esc_html_e( '','pistacia' );?></span></h1>
                                <input type="text" name="rsrvCode" class="form-control hidden rsrvCode" placeholder="" value="">
                                <div class="row">
                                    <div class="col-xs-6">
                                        <input type="text" name="reservation_first_name" id="reservation_first_name" class="form-control" placeholder="<?php esc_html_e( 'Förnamn','pistacia' );?> *" required>
                                    </div>
                                    <div class="col-xs-6">
                                        <input type="text" name="reservation_last_name" id="reservation_last_name" class="form-control" placeholder="<?php esc_html_e( 'Efternamn','pistacia' );?> *" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-6">
                                        <input type="text" name="reservation_email" id="reservation_email" class="form-control" placeholder="<?php esc_html_e( 'E-post','pistacia' );?> *" required>
                                    </div>
                                    <div class="col-xs-6">
                                        <input type="text" name="reservation_phone" id="reservation_phone" class="form-control" placeholder="<?php esc_html_e( 'Telefon','pistacia' );?> *" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-6">
                                        <input type="text" class="form-control" name="reservation_guest_number" id="reservation_guest_number" placeholder="<?php esc_html_e( 'Företagsnamn','pistacia' );?>" required>
                                    </div>
                                    <div class="col-xs-6">
                                                <input type="text" class="form-control hidden" name="reservation_date" value="" id="reservation_date" placeholder="" required="">
                                            <select class="form-control" name="reservation_time" id="reservation_time">
                                                <option value="None">Välj starttid</option>
                                                <option value="12:30">12:30</option>
                                                <option value="13:30">13:30</option>
                                                <option value="14:30">14:30</option>
                                            </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-12">
                                        <span style="float: left; margin-right: 10px;"><input type="checkbox" value="Paketerbjudanden"> Paketerbjudanden</span>
                                        <span style="float: left; margin-right: 10px;"><input type="checkbox" value="Föreläsningar Matlagningskurser"> Föreläsningar Matlagningskurser</span>
                                        <span style="float: left; margin-right: 10px;"><input type="checkbox" value="Matlagningsaktiviteter"> Matlagningsaktiviteter</span>
                                        <span style="float: left; margin-right: 10px;"><input type="checkbox" value="Tjänster för förskola & skola
"> Tjänster för förskola & skola
</span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-12">
                                        <textarea name="reservation_message" id="reservation_message" class="form-control reservation-message" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-<?php echo esc_attr($columns);?><?php echo ( !get_sub_field('pistacia_spclts_calendar') ) ? ' fadeInRight-ifAppeared' : ' hide'; ?>">
                                <h1><span class="light"><?php esc_html_e( 'Välj','pistacia' );?></span> <span class="extra-bold"><?php esc_html_e( 'datum','pistacia' );?></span></h1>
                                <div id="datepicker" class="datepicker-dark"></div>
                            </div>
                            <div class="col-md-12 animated fadeIn">
                                <a class="btn btn-transparent hvr-shutter-out-horizontal btn-send"><?php esc_html_e( 'Skicka förfrågan','pistacia' );?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        <?php }



    }

}