<?php
/**
 * pistacia_acf_pro.php
 *
 * This file Pistacia_Acf_Pro class
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.2.0
 */

require_once( Pistacia_Helpers::get_template_directory() . '/acf_pro/acf_pro_options.php');
require_once( Pistacia_Helpers::get_template_directory() . '/acf_pro/acf_pro_page_builder.php');
require_once( Pistacia_Helpers::get_template_directory() . '/acf_pro/acf_pro_posts_page.php');

if ( !class_exists( 'Pistacia_Acf_Pro' ) )
{
    class Pistacia_Acf_Pro
    {
        private static $instance;

        protected function __construct()
        {
            define('ACF_LITE',true);

            if ( function_exists( 'acf_add_options_page' ) ) {

                acf_add_options_page( array(
                    'page_title' => esc_html__( 'Pistacia Settings', 'pistacia' ),
                    'menu_slug'  => 'pistacia_settings',
                    'position'   => 64,
                    'redirect'   => false
                ) );
            }

        }

        public static function get_instance()
        {
            if (null === static::$instance) {
                static::$instance = new static();
            }
            return static::$instance;
        }

    }

}