<?php
/**
 * author.php
 *
 * This file contains author template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */?>

<?php get_header();?>

<header class="header">
    <div class="header-img" style="background-image:url('<?php header_image(); ?>');">
        <div class="overlay overlay-black-70"></div>
    </div>
</header>

<section class="author-section">

    <div class="inner">

        <div class="container">

            <div id="author-info" class="author-info">

                <div class="col-md-3">
                    <div id="author-avatar" class="author-avatar">
                        <?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 200,200 ) ); ?>
                    </div>
                </div>

                <div class="col-md-8">

                    <div class="author-description">

                        <h1><?php the_author_meta( 'first_name' ); ?> <?php the_author_meta( 'last_name' ); ?></h1>
                        <span class="">E-mail:</span> <a href="mailto:<?php echo antispambot(get_the_author_meta( 'user_email' )); ?>"><?php echo antispambot(get_the_author_meta( 'user_email' )); ?></a>
                        <h3><?php the_author_meta( 'user_nicename' ); ?></h3>
                        <?php the_author_meta( 'description' ); ?>

                    </div>

                </div>

            </div>

        </div>

</section>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer();?>
