/* Swedish initialisation for the jQuery UI date picker plugin. */
( function (factory) {
    if (typeof define === "function" && define.amd) {

        // AMD. Register as an anonymous module.
        define(["../widgets/datepicker"], factory);
    } else {

        // Browser globals
        factory(jQuery.datepicker);
    }
}(function (datepicker) {

    datepicker.regional.sv = {
        closeText: 'Stäng',
        prevText: '< Föregående',
        nextText: 'Nästa >',
        currentText: 'Nu',
        monthNames: ['Januari', 'Februari', 'Mars', 'April', 'Maj', 'Juni', 'Juli', 'Augusti', 'September', 'Oktober', 'November', 'December'],
        monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'Maj', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
        dayNamesShort: ['Sön', 'Mån', 'Tis', 'Ons', 'Tor', 'Fre', 'Lör'],
        dayNames: ['Söndag', 'Måndag', 'Tisdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lördag'],
        dayNamesMin: ['Sö', 'Må', 'Ti', 'On', 'To', 'Fr', 'Lö'],
        weekHeader: 'Не',
        dateFormat: 'dd mm yy',
        firstDay: 1,
        isRTL: false,
        showMonthAfterYear: false,
        yearSuffix: ""
    };
    datepicker.setDefaults(datepicker.regional.sv);

    return datepicker.regional.sv;

}));

var APP = {windowWidth: null};
APP.init = function () {
    "use strict";
    this.windowWidth = this.setWindowWidth(), this.pageloader(), this.hovermenu(), this.bootstrap(), this.scrollto(), this.navsearch(), this.animateElementIfAppear(), this.swipeboxRun(), this.stickynav(), this.plax(), this.createGoogleMap(), this.contactForm(), this.counterNumbers(), this.isotops(), this.portfolio(), this.parallax(), this.shop(), this.swiperSlider(), this.socialShare(), this.navsideMenu(), this.flexSlider(), this.reservationForm(), this.zoomInside(), this.vcBugfix(), this.wpMenu(), jQuery(window).scroll(function () {
        APP.windowWidth = APP.setWindowWidth()
    }), jQuery(window).resize(function () {
        APP.windowWidth = APP.setWindowWidth()
    })
}, APP.wpMenu = function () {
    jQuery.fn.pistacia_wp_menu = function (a) {
        return this.each(function () {
            var b = jQuery(this), c = {};
            jQuery.extend(c, a);
            jQuery(".menu-item-has-children > a", jQuery(b)).on("click", function (a) {
                var b = jQuery(this);
                b.next("ul").slideToggle(), a.preventDefault()
            })
        })
    }, jQuery("ul.menu").pistacia_wp_menu()
}, APP.vcBugfix = function () {
    jQuery(".vc_row .vc-no-fixed-menu").parents(".vc_row").css({overflow: "visible"})
}, APP.swiperSlider = function () {
    "use strict";
    jQuery(document).ready(function () {
        if (jQuery(".interested-in-carousel").length) {
            new Swiper(".interested-in-carousel", {
                pagination: ".interested-swiper-pagination",
                direction: "horizontal",
                loop: !0,
                slidesPerView: 4,
                paginationClickable: !0,
                spaceBetween: 20,
                breakpoints: {
                    1024: {slidesPerView: 3, spaceBetween: 20},
                    768: {slidesPerView: 3, spaceBetween: 20},
                    640: {slidesPerView: 1, spaceBetween: 20},
                    320: {slidesPerView: 1, spaceBetween: 10}
                }
            })
        }
        if (jQuery(".reviews-swiper-container").length) {
            new Swiper(".reviews-swiper-container", {
                direction: "horizontal",
                loop: !0,
                autoplay: 3e3,
                slidesPerView: 1,
                spaceBetween: 0
            })
        }
        if (jQuery(".logo-swiper-container").length) {
            new Swiper(".logo-swiper-container", {
                nextButton: ".logo-swiper-button-next",
                prevButton: ".logo-swiper-button-prev",
                pagination: ".logo-swiper-pagination",
                paginationClickable: !0,
                slidesPerView: 6,
                loop: !0,
                spaceBetween: 20,
                breakpoints: {
                    1024: {slidesPerView: 5, spaceBetween: 40},
                    768: {slidesPerView: 3, spaceBetween: 20},
                    640: {slidesPerView: 2, spaceBetween: 10},
                    320: {slidesPerView: 1, spaceBetween: 0}
                }
            })
        }
        if (jQuery(".testimonal-swiper-container").length) {
            new Swiper(".testimonal-swiper-container", {
                pagination: ".testimonal-swiper-pagination",
                paginationClickable: !0,
                slidesPerView: 1,
                loop: !0,
                spaceBetween: 0
            })
        }
        if (jQuery(".recipes-header-swiper-container").length) {
            new Swiper(".recipes-header-swiper-container", {
                pagination: ".recipes-header-swiper-pagination",
                nextButton: ".recipes-header-swiper-button-next",
                prevButton: ".recipes-header-swiper-button-prev",
                paginationClickable: !0,
                effect: "fade",
                slidesPerView: 1,
                loop: !0,
                spaceBetween: 0
            })
        }
        if (jQuery(".services-carousels-swiper-container").length) {
            new Swiper(".services-carousels-swiper-container", {
                pagination: ".services_carousels-swiper-pagination",
                nextButton: ".services_carousels-swiper-button-next",
                prevButton: ".services_carousels-swiper-button-prev",
                paginationClickable: !0,
                slidesPerView: 2,
                spaceBetween: 30,
                breakpoints: {320: {slidesPerView: 1, spaceBetween: 0}},
                loop: !0
            })
        }
    })
}, APP.zoomInside = function () {
    "use strict";
    jQuery(".zoom").length && jQuery(".zoom").zoom()
}, APP.shop = function () {
    "use strict";
    jQuery(".view-mode").find("a").on("click", function (a) {
        a.preventDefault();
        var b = jQuery(this).data("mode");
        jQuery("a", jQuery(this).parents(".view-mode")).each(function () {
            var a = jQuery(this).data("mode");
            jQuery("#shop").removeClass(a)
        }), jQuery(this).siblings().removeClass("active").end().addClass("active"), jQuery("#shop").addClass(b)
    })
}, APP.isotops = function () {
    "use strict";
    jQuery.fn.pistaciaIsotopePosts = function (a) {
        return jQuery(this).each(function () {
            var b = jQuery(this), c = {
                post_per_page: b.data("post-per-page"),
                more_posts_button: b.parents(".isotope-posts-section").next(".more-button-section"),
                container: jQuery(".isotope-grids", b),
                loader: jQuery(".item-loading", b),
                post_type: b.data("post-type") ? b.data("post-type") : "post",
                isotopegrid: null,
                paged: 1
            }, d = function (a, b) {
                var d = null, e = a.split(",");
                e.forEach(function (a) {
                    var b = a.split("=");
                    "paged" == b[0] && (d = b[1])
                });
                var f = null;
                jQuery.ajax({
                    type: "post",
                    url: pistacia_application_localize.ajax_url,
                    data: "args=" + a + "&action=pistacia_ajax_getposts",
                    success: function (a) {
                        f = jQuery(a), "" != f && c.more_posts_button.data("paged", d)
                    },
                    error: function () {
                    }
                }).then(function () {
                    f.length > 0 ? ("add" == b && (c.container.append(f), jQuery("img.wait-for-load").imagesLoaded(function () {
                        c.container.isotope(), c.loader.hide()
                    })), "append" == b && (c.container.append(f), jQuery("img.wait-for-load").imagesLoaded(function () {
                        c.container.isotope("appended", f), c.loader.hide()
                    }))) : (c.more_posts_button.hide(), c.loader.hide())
                })
            };
            jQuery.extend(c, a), d("paged=" + c.paged + ",posts_per_page=" + c.post_per_page + ",post_type=" + c.post_type, "add"), c.more_posts_button.on("click", function (a) {
                var b = jQuery(this);
                c.loader.show();
                var e = parseInt(b.data("paged")) + 1;
                d("paged=" + e + ",posts_per_page=" + c.post_per_page + ",post_type=" + c.post_type, "append"), a.preventDefault()
            }), jQuery(".posts-filters").on("click", "a", function (a) {
                a.preventDefault();
                var b = jQuery(this), d = b.parent(), e = b.attr("data-filter");
                c.container.isotope({filter: e}), d.addClass("active").siblings().removeClass("active")
            })
        })
    }, jQuery(".pistacia-isotopes").pistaciaIsotopePosts()
}, APP.navsideMenu = function () {
    "use strict";
    document.querySelector(".collapse-menu") && (jQuery(".collapse-menu li").each(function () {
        var a = jQuery(this);
        a.has("ul").length > 0 && a.addClass("has-dropdown")
    }), jQuery(".collapse-menu a").on("click", function (a) {
        var b = jQuery(this), c = b.parent("li");
        c.has("ul").length > 0 && (a.preventDefault(), b.next("ul").slideToggle(function () {
            c.toggleClass("active")
        }))
    }))
}, APP.socialShare = function () {
    "use strict";
    jQuery(document).ready(function () {
        jQuery(".social-share-button").click(function (a) {
            return a.preventDefault(), window.open(jQuery(this).attr("href"), "fbShareWindow", "height=450, width=550, top=" + (jQuery(window).height() / 2 - 275) + ", left=" + (jQuery(window).width() / 2 - 225) + ", toolbar=0, location=0, menubar=0, directories=0, scrollbars=0"), !1
        })
    })
}, APP.swipeboxRun = function () {
    jQuery(".swipebox").swipebox()
}, APP.navsearch = function () {
    "use strict";
    var a = jQuery("#desktopSearch");
    jQuery(document).ready(function () {
        jQuery("#desktopSearchButton").on("click", function (b) {
            b.preventDefault(), a.addClass("active")
        }), jQuery("#desktopSearchClose").on("click", function (b) {
            b.preventDefault(), a.removeClass("active")
        })
    })
}, APP.counterNumbers = function () {
    "use strict";
    if (jQuery(".counter-number").length) {
        var a = {useEasing: !0, useGrouping: !0, separator: ",", decimal: ".", prefix: "", suffix: ""}, b = [], c = [];
        jQuery.each(jQuery(".counter-number"), function () {
            b.push(jQuery(this).attr("id"))
        }), b.forEach(function (b) {
            var d = new countUp(b, 0, parseInt(jQuery("#" + b).html(), 10), 0, 10, a);
            c.push(d), d++
        }), jQuery(window).scroll(function () {
            b.forEach(function (a, b) {
                var d = jQuery("#" + a).offset().top, e = jQuery(window).scrollTop() + jQuery(window).height();
                d < e && c[b].start()
            })
        })
    }
}, APP.parallax = function () {
    "use strict";
    jQuery("#counterParallax").parallax("50%", .4, !1), jQuery(".header-img").parallax("50%", .4, !1), jQuery("#signUpNews").parallax("50%", .4, !1)
}, APP.setWindowWidth = function () {
    "use strict";
    return document.body.clientWidth
}, APP.scrollto = function () {
    "use strict";
    jQuery(document).ready(function () {
        jQuery("a.scroll-to").on("click", function (a) {
            var b = jQuery(this).attr("href"), c = 60;
            a.preventDefault(), jQuery(window).scrollTo(jQuery(b).offset().top - c, 800, {easing: "easeInOutExpo"})
        })
    })
},



    APP.reservationForm = function () {
        "use strict";
        if (document.getElementById("datepicker")) {
            var a = jQuery("#datepicker");
            var b = a.datepicker({
                onSelect: function (a) {
                    jQuery("#reservation_date").val(a)
                }
            }).datepicker({dateFormat: "yy-mm-dd"},{regional: "sv"}).val();
            document.getElementById("reservation_date").value = b;
        }

        var c = jQuery(".reservation_form");
        c.length && c.each(function () {
            var a = jQuery(this);
            a.find(".btn-send").on("click", function (b) {
                var c = jQuery(this);
                a.validate({
                    rules: {
                        reservation_first_name: "required",
                        reservation_last_name: "required",
                        reservation_email: {required: !0, email: !0},
                        reservation_guest_number: {required: !0, number: !0},
                        reservation_phone: {required: !0}
                    },
                    messages: {
                        reservation_first_name: pistacia_application_localize.validator_required_element,
                        reservation_last_name: pistacia_application_localize.validator_required_element,
                        email: {
                            required: pistacia_application_localize.validator_required_element,
                            email: pistacia_application_localize.validator_does_not_email
                        },
                        reservation_phone: {required: pistacia_application_localize.validator_required_element},
                        reservation_guest_number: {
                            required: pistacia_application_localize.validator_required_element,
                            number: pistacia_application_localize.validator_does_not_number
                        }
                    }
                });
                return a.valid() === !0 && "" === jQuery(".rsrvCode", a).val() && (c.button("loading"), jQuery.ajax({
                        type: "POST",
                        url: pistacia_application_localize.ajax_url,
                        data: a.serialize() + "&action=pistacia_ajaxreservation_send_mail",
                        success: function () {
                            c.button("reset"), a[0].reset(), toastr.success(pistacia_application_localize.form_success), b.preventDefault()
                        },
                        error: function () {
                            c.button("reset")
                        }
                    }), void b.preventDefault())
            })
        })
    }, APP.contactForm = function () {
    "use strict";
    if (document.getElementById("cntForm")) {
        var a = jQuery("#cntForm");
        a.find(".btn-send").on("click", function (b) {
            var c = jQuery(this);
            a.validate({
                rules: {contact_name: "required", contact_email: {required: !0, email: !0}},
                messages: {
                    contact_name: pistacia_application_localize.validator_required_element,
                    contact_email: {
                        required: pistacia_application_localize.validator_required_element,
                        email: pistacia_application_localize.validator_does_not_email
                    }
                }
            });
            return a.valid() === !0 && "" === jQuery("#cntCode").val() && (c.button("loading"), jQuery.ajax({
                    type: "post",
                    url: pistacia_application_localize.ajax_url,
                    data: a.serialize() + "&action=pistacia_ajaxcontact_send_mail",
                    success: function (d) {
                        a[0].reset(), toastr.success(pistacia_application_localize.form_success), b.preventDefault(), c.button("reset")
                    },
                    error: function () {
                        toastr.error(pistacia_application_localize.form_error), b.preventDefault(), c.button("reset")
                    }
                }), void b.preventDefault())
        })
    }
}, APP.portfolio = function () {
    "use strict";
    if (document.querySelector(".portfolio-items")) {
        var a = null;
        jQuery(".portfolio-items").imagesLoaded(function () {
            a = jQuery(".portfolio-items").isotope()
        }), jQuery(".portfolio-filters").on("click", "a", function (b) {
            b.preventDefault();
            var c = jQuery(this), d = c.parent(), e = c.attr("data-filter");
            a.isotope({filter: e}), d.addClass("active").siblings().removeClass("active")
        })
    }
    jQuery.fn.filteredPortfolio = function (a) {
        var b = [], c = function (c) {
            f(c), c.find(a.itemSelector).each(function () {
                b.push(jQuery(this))
            }), c.imagesLoaded(function () {
                c.masonry()
            })
        }, d = function (a) {
            var c = [];
            return jQuery(b).each(function (d) {
                jQuery(a).each(function (a, e) {
                    b[d].is(e) && jQuery.inArray(b[d], c) === -1 && c.push(b[d])
                })
            }), c
        }, e = function (a, b) {
            a.empty(), jQuery(b).each(function () {
                jQuery(a).append(jQuery(this))
            }), a.masonry("reloadItems"), a.masonry()
        }, f = function (c) {
            jQuery(a.filtersGroupSelector).find("input[type=checkbox]").each(function () {
                jQuery(this).change(function () {
                    var f = [];
                    jQuery(a.filtersGroupSelector).find("input[type=checkbox]").each(function () {
                        jQuery(this).is(":checked") && f.push("." + jQuery(this).val())
                    });
                    var g = b;
                    f.length > 0 && (g = d(f)), e(c, g)
                })
            })
        };
        return this.each(function () {
            c(jQuery(this))
        })
    }, jQuery(".portfolio-items").length && jQuery(".portfolio-items").filteredPortfolio({
        itemSelector: ".item",
        filtersGroupSelector: ".filters"
    })
}, APP.createGoogleMap = function () {
    "use strict";
    var a = document.getElementById("map-canvas"), b = [];
    jQuery(".marker", jQuery(a)).each(function () {
        var a = {};
        a.lat = jQuery(this).data("lat"), a.lng = jQuery(this).data("lng"), a.text = jQuery(this).data("text"), b.push(a)
    }), a && +function (c, d, e) {
        var f = e.MAP_OPTIONS;
        if (e.MAP_OPTIONS.styles = [{
                featureType: "administrative",
                elementType: "geometry",
                stylers: [{hue: "#ff0000"}]
            }, {
                featureType: "administrative",
                elementType: "labels.text.fill",
                stylers: [{color: "#444444"}]
            }, {
                featureType: "landscape",
                elementType: "all",
                stylers: [{color: "#f2f2f2"}]
            }, {
                featureType: "landscape.man_made",
                elementType: "geometry",
                stylers: [{hue: "#ff0000"}]
            }, {featureType: "poi", elementType: "all", stylers: [{visibility: "off"}]}, {
                featureType: "poi.business",
                elementType: "all",
                stylers: [{visibility: "on"}, {hue: "#00ffed"}, {saturation: "2"}, {lightness: "4"}, {weight: "2.07"}]
            }, {
                featureType: "road",
                elementType: "all",
                stylers: [{saturation: -100}, {lightness: 45}]
            }, {
                featureType: "road.highway",
                elementType: "all",
                stylers: [{visibility: "simplified"}]
            }, {
                featureType: "road.arterial",
                elementType: "labels.icon",
                stylers: [{visibility: "off"}]
            }, {featureType: "transit", elementType: "all", stylers: [{visibility: "off"}]}, {
                featureType: "water",
                elementType: "all",
                stylers: [{color: "#46bcec"}, {visibility: "on"}]
            }], jQuery(a).data("lat") && jQuery(a).data("lng") && jQuery(a).data("zoom")) {
            e.MAP_OPTIONS.center.lat = parseFloat(jQuery(a).data("lat")), e.MAP_OPTIONS.center.lng = parseFloat(jQuery(a).data("lng")), e.MAP_OPTIONS.zoom = parseInt(jQuery(a).data("zoom")), /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) && (e.MAP_OPTIONS.draggable = !1);
            var g = e.create(a, f);
            b && b.forEach(function (a) {
                g.addMarker({
                    position: {lat: parseFloat(a.lat), lng: parseFloat(a.lng)},
                    event: {
                        name: "click", callback: function () {
                        }
                    },
                    content: '<div class="marker-text" style="width:200px">' + a.text + "</div>",
                    contentShow: !1,
                    id: 1,
                    draggable: !1,
                    icon: pistacia_application_localize.stylesheet_directory + "/assets/img/map.png"
                })
            })
        }
    }(window, google, window.Mapster || (window.Mapster = {}))
}, APP.plax = function () {
    "use strict";
    document.getElementById("page404") && (jQuery("#page404 #layer-1").plaxify({
        xRange: 0,
        yRange: 0
    }), jQuery("#psge404 #layer-2").plaxify({xRange: 20, yRange: 20}), jQuery("#page404 #layer-3").plaxify({
        xRange: 40,
        yRange: 40
    }), jQuery("#page404 #layer-5").plaxify({xRange: 50, yRange: 50}), jQuery("#page404 #layer-6").plaxify({
        xRange: 110,
        yRange: 20
    }), jQuery("#page404 #layer-7").plaxify({
        xRange: 140,
        yRange: 70
    }), jQuery("#page404 #layer-8").plaxify({
        xRange: 320,
        yRange: 120
    }), jQuery("#page404 #layer-9").plaxify({xRange: 40, yRange: 0}), jQuery.plax.enable({
        clearLayers: !0,
        restorePositions: !0,
        activityTarget: jQuery(".plax-wrapper")
    }))
}, APP.flexSlider = function () {
    "use strict";
    document.querySelector(".shop-item-carousel") && jQuery(window).load(function () {
        jQuery("#shop-item-carousel").flexslider({
            animation: "fade",
            controlNav: !1,
            animationLoop: !1,
            directionNav: !1,
            slideshow: !1,
            sync: "#shop-item-carousel-nav"
        }), jQuery("#shop-item-carousel-nav").flexslider({
            animation: "slide",
            controlNav: !1,
            directionNav: !0,
            animationLoop: !1,
            slideshow: !1,
            itemWidth: 130,
            itemMargin: 5,
            asNavFor: "#shop-item-carousel"
        })
    })
}, APP.hovermenu = function () {
    "use strict";
    jQuery(".top-menu li").each(function () {
        var a = jQuery(this);
        a.has("ul").length > 0 && (jQuery(this).find(">ul").addClass("sub-menu"), jQuery(this).find(">a").addClass("trigger"), a.find(">a").on("click", function (a) {
          //  a.preventDefault()
            // alert(this.href);
            window.location.href = this.href;
        }))
    }), jQuery(".dropdown-menu > li > a.trigger").on("click", function (a) {
        var b = jQuery(this).next(), c = jQuery(this).parent().parent();
        c.find(".sub-menu:visible").not(b).hide(), b.toggle(), a.stopPropagation()
    }), jQuery(".dropdown-menu > li > a:not(.trigger)").on("click", function () {
        var a = jQuery(this).closest(".dropdown");
        a.find(".left-caret").toggleClass("right-caret left-caret"), a.find(".sub-menu:visible").hide()
    })
}, APP.animateElementIfAppear = function () {
    "use strict";
    jQuery(window).scroll(function () {
        jQuery("[class$=-ifAppeared]").each(function () {
            var a = jQuery(this).offset().top, b = jQuery(window).scrollTop() + jQuery(window).height() - 300, c = jQuery(this).attr("class").split(" "), d = "";
            jQuery.each(c, function (a, b) {
                var c = b.split("-");
                "ifAppeared" == c[1] && (d = c[0])
            }), a < b && jQuery(this).addClass("animated " + d)
        })
    })
}, APP.stickynav = function () {
    var a = jQuery("#pistacia-top-navigation");
    if (a.length) {
        var b = a.offset().top, c = function () {
            var c = jQuery(window).scrollTop();
            c > b ? a.parent().addClass("sticky-on") : a.parent().removeClass("sticky-on")
        };
        c(), jQuery(window).scroll(c), jQuery(window).resize(c)
    }
}, APP.bootstrap = function () {
    "use strict";
    if (navigator.userAgent.match(/IEMobile\/10\.0/)) {
        var a = document.createElement("style");
        a.appendChild(document.createTextNode("@-ms-viewport{width:auto!important}")), document.querySelector("head").appendChild(a)
    }
    jQuery("body").tooltip({
        selector: '[data-toggle="tooltip"]',
        trigger: "hover"
    }), jQuery(".wp-tab-content .nav-tabs a").click(function (a) {
        a.preventDefault(), jQuery(this).tab("show")
    }), jQuery(".panel-heading a").click(function () {
        jQuery(".panel-heading").removeClass("active"), jQuery(this).parents(".panel-heading").addClass("active")
    })
}, APP.pageloader = function () {
    "use strict";
    jQuery(document).imagesLoaded(function () {
        jQuery(".page-loader").delay(100).fadeOut(500)
    })
}, APP.init();