/** APPLICATION.JS
 =====================================================================================
 This file contains custom javascripts and plugins initialize
 =====================================================================================
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 =====================================================================================*/

/*-----------------------------------------------*/
/* Application */
/*-----------------------------------------------*/

var APP = {
    windowWidth: null
};


/*-----------------------------------------------*/
/* Initialize
 /*-----------------------------------------------*/

APP.init = function () {

    "use strict";

    this.windowWidth = this.setWindowWidth();

    this.pageloader();
    this.hovermenu();
    this.bootstrap();
    this.scrollto();
    this.navsearch();
    this.animateElementIfAppear();
    this.swipeboxRun();
    this.stickynav();
    this.plax();
    this.createGoogleMap();
    this.contactForm();
    this.counterNumbers();
    this.isotops();
    this.portfolio();
    this.parallax();
    this.shop();
    this.swiperSlider();
    this.socialShare();
    this.navsideMenu();
    this.flexSlider();
    this.reservationForm();
    this.zoomInside();
    this.vcBugfix();
    this.wpMenu();

    jQuery(window).scroll(function () {
        APP.windowWidth = APP.setWindowWidth();
    });
    jQuery(window).resize(function () {
        APP.windowWidth = APP.setWindowWidth();
    });
};

APP.wpMenu = function(){

    jQuery.fn.pistacia_wp_menu = function( opts ){

        return this.each(function(){
            var menu = jQuery( this );
            var args = {};
            var options = jQuery.extend(args, opts);

            jQuery('.menu-item-has-children > a', jQuery(menu) ).on('click',function(e){
                var _this = jQuery(this);
                _this.next('ul').slideToggle();
                e.preventDefault();
            });

        });

    };

    jQuery('ul.menu').pistacia_wp_menu();

}


/**
 * Visual composer overflow hidden all vc_row
 * Top menu submenu not show. So overflow hidden overwrite
 */
APP.vcBugfix = function(){
    jQuery('.vc_row .vc-no-fixed-menu').parents('.vc_row').css({
        'overflow' : 'visible'
    });
};


/**
 * Swiper slider
 */
APP.swiperSlider = function(){

    "use strict";

    jQuery(document).ready(function () {

        if( jQuery('.interested-in-carousel').length ) {

            var mySwiper = new Swiper('.interested-in-carousel', {
                pagination: '.interested-swiper-pagination',
                direction: 'horizontal',
                loop: true,
                slidesPerView: 4,
                paginationClickable: true,
                spaceBetween: 20,
                breakpoints: {
                    1024: {
                        slidesPerView: 3,
                        spaceBetween: 20
                    },
                    768: {
                        slidesPerView: 3,
                        spaceBetween: 20
                    },
                    640: {
                        slidesPerView: 1,
                        spaceBetween: 20
                    },
                    320: {
                        slidesPerView: 1,
                        spaceBetween: 10
                    }
                }
            });

        }

        if( jQuery('.reviews-swiper-container').length ) {


            var reviews_swiper = new Swiper('.reviews-swiper-container', {
                direction: 'horizontal',
                loop: true,
                autoplay:3000,
                slidesPerView: 1,
                spaceBetween: 0
            });

        }

        if( jQuery('.logo-swiper-container').length ){
            var logo_swiper = new Swiper('.logo-swiper-container', {
                nextButton: '.logo-swiper-button-next',
                prevButton: '.logo-swiper-button-prev',
                pagination: '.logo-swiper-pagination',
                paginationClickable: true,
                slidesPerView: 6,
                loop:true,
                spaceBetween: 20,
                breakpoints: {
                    1024: {
                        slidesPerView: 5,
                        spaceBetween: 40
                    },
                    768: {
                        slidesPerView: 3,
                        spaceBetween: 20
                    },
                    640: {
                        slidesPerView: 2,
                        spaceBetween: 10
                    },
                    320: {
                        slidesPerView: 1,
                        spaceBetween: 0
                    }
                }
            });

        }

        if( jQuery('.testimonal-swiper-container').length ){
            var testimonal_swiper = new Swiper('.testimonal-swiper-container', {
                pagination: '.testimonal-swiper-pagination',
                paginationClickable: true,
                slidesPerView: 1,
                loop:true,
                spaceBetween: 0
            });
        }

        if( jQuery('.recipes-header-swiper-container').length ){
            var recipes_header_swiper = new Swiper('.recipes-header-swiper-container', {
                pagination: '.recipes-header-swiper-pagination',
                nextButton: '.recipes-header-swiper-button-next',
                prevButton: '.recipes-header-swiper-button-prev',
                paginationClickable: true,
                effect:'fade',
                slidesPerView: 1,
                loop:true,
                spaceBetween: 0
            });
        }

        if( jQuery('.services-carousels-swiper-container').length ){
            var services_carousels_swiper = new Swiper('.services-carousels-swiper-container', {
                pagination: '.services_carousels-swiper-pagination',
                nextButton: '.services_carousels-swiper-button-next',
                prevButton: '.services_carousels-swiper-button-prev',
                paginationClickable: true,
                slidesPerView: 2,
                spaceBetween: 30,
                breakpoints: {
                    320: {
                        slidesPerView: 1,
                        spaceBetween: 0
                    }
                },
                loop:true
            });
        }

    });

};


/**
 * Zoom plugin
 */
APP.zoomInside = function(){

    "use strict";

    if(jQuery('.zoom').length) {
        jQuery('.zoom').zoom();
    }

};


/*-----------------------------------------------*/
/* Shop */
/*-----------------------------------------------*/

APP.shop = function () {

    "use strict";

    jQuery('.view-mode').find('a').on('click', function (e) {

        e.preventDefault();
        var mode = jQuery(this).data('mode');
        jQuery('a', jQuery(this).parents('.view-mode')).each(function () {
            var mode = jQuery(this).data('mode');
            jQuery('#shop').removeClass(mode);
        });
        jQuery(this)
            .siblings().removeClass('active').end()
            .addClass('active');
        jQuery('#shop').addClass(mode);
    });
};



/*-----------------------------------------------*/
/* Isotopes */
/*-----------------------------------------------*/
APP.isotops = function(){

    "use strict";

    jQuery.fn.pistaciaIsotopePosts = function( args ){

        return jQuery(this).each(function(){

            var _this = jQuery(this);

            var opts = {
                post_per_page : _this.data('post-per-page'),
                more_posts_button : _this.parents('.isotope-posts-section').next('.more-button-section'),
                container : jQuery('.isotope-grids', _this),
                loader : jQuery('.item-loading',_this),
                post_type : (_this.data('post-type')) ? _this.data('post-type') : 'post',
                isotopegrid : null,
                paged : 1
            };

            var add_posts_with_ajax = function( args, methode ){

                var currentPaged = null;
                var spl = args.split(',');

                spl.forEach( function( value ){
                    var arg = value.split('=');
                    if (arg[0] == 'paged'){
                        currentPaged = arg[1];
                    }
                } );

                var elems = null;

                jQuery.ajax({
                    type: "post",
                    url: pistacia_application_localize['ajax_url'],
                    data: 'args=' + args + '&action=pistacia_ajax_getposts',
                    success: function ( items ) {
                        elems = jQuery( items );
                        if ( elems != '' ) {
                            opts.more_posts_button.data( 'paged', currentPaged );
                        }
                    },
                    error: function () {

                    }
                }).then(function(){

                    if( elems.length > 0 ) {
                        if (methode == 'add') {
                            opts.container.append(elems);
                            jQuery('img.wait-for-load').imagesLoaded(function () {
                                opts.container.isotope();
                                opts.loader.hide();
                            });
                        }
                        if (methode == 'append') {
                            opts.container.append(elems);
                            jQuery('img.wait-for-load').imagesLoaded(function () {
                                opts.container.isotope('appended', elems);
                                opts.loader.hide();
                            });
                        }
                    } else {
                        opts.more_posts_button.hide();
                        opts.loader.hide();
                    }

                });

            };

            jQuery.extend(opts,args);

            add_posts_with_ajax( 'paged='+ opts.paged +',posts_per_page=' + opts.post_per_page + ',post_type='+opts.post_type, 'add' );

            opts.more_posts_button.on('click',function(e){
                var _this = jQuery( this );
                opts.loader.show();
                var paged = parseInt(_this.data('paged')) + 1;
                add_posts_with_ajax( 'paged=' + paged + ',posts_per_page=' + opts.post_per_page + ',post_type='+opts.post_type, 'append' );
                e.preventDefault();
            });

            jQuery('.posts-filters').on('click', 'a', function (e) {
                e.preventDefault();
                var _this = jQuery(this);
                var _parent = _this.parent();
                var _filterValue = _this.attr('data-filter');
                opts.container.isotope({filter: _filterValue});
                _parent
                    .addClass('active')
                    .siblings()
                    .removeClass('active');
            });

        });

    };

    jQuery('.pistacia-isotopes').pistaciaIsotopePosts();

};



/*-----------------------------------------------*/
/* Navside menu */
/*-----------------------------------------------*/
APP.navsideMenu=function(){

    "use strict";

    if(document.querySelector('.collapse-menu')) {
        jQuery('.collapse-menu li').each(function(){
            var _this = jQuery(this);
            if(_this.has('ul').length > 0){
                _this.addClass('has-dropdown');
            }
        });
        jQuery('.collapse-menu a').on('click', function (e) {
            var _this = jQuery(this);
            var parent = _this.parent('li');
            if ( parent.has('ul').length > 0 ){
                e.preventDefault();
                _this.next('ul').slideToggle(function(){
                    parent.toggleClass('active');
                });
            }
        });
    }
};



/*-----------------------------------------------*/
/* Social share button */
/*-----------------------------------------------*/

APP.socialShare = function() {

    "use strict";

    jQuery(document).ready(function () {
        jQuery('.social-share-button').click(function (e) {
            e.preventDefault();
            window.open(jQuery(this).attr('href'), 'fbShareWindow', 'height=450, width=550, top=' + (jQuery(window).height() / 2 - 275) + ', left=' + (jQuery(window).width() / 2 - 225) + ', toolbar=0, location=0, menubar=0, directories=0, scrollbars=0');
            return false;
        });
    });
};



/*-----------------------------------------------*/
/* Swipebox */
/*-----------------------------------------------*/

APP.swipeboxRun = function(){

    jQuery( '.swipebox' ).swipebox();

};



/*-----------------------------------------------*/
/* Top navigation search */
/*-----------------------------------------------*/

APP.navsearch = function () {

    "use strict";

    var desktopsearch = jQuery("#desktopSearch");

    jQuery(document).ready(function () {

        jQuery('#desktopSearchButton').on('click', function (e) {
            e.preventDefault();
            desktopsearch.addClass('active');
        });

        jQuery('#desktopSearchClose').on('click', function (e) {
            e.preventDefault();
            desktopsearch.removeClass('active');
        });

    });

};



/*-----------------------------------------------*/
/* Counter numbers */
/*-----------------------------------------------*/

APP.counterNumbers = function () {

    "use strict";

    if ( jQuery('.counter-number').length ) {
        var options = {
            useEasing: true,
            useGrouping: true,
            separator: ',',
            decimal: '.',
            prefix: '',
            suffix: ''
        };

        var counterNumbersId = [];
        var counters = [];
        var a = 0;

        jQuery.each(jQuery('.counter-number'), function () {
            counterNumbersId.push(jQuery(this).attr('id'));
        });

        counterNumbersId.forEach(function (value) {
            var a = new countUp(value, 0, parseInt(jQuery("#" + value).html(), 10), 0, 10, options);
            counters.push(a);
            a++;
        });

        jQuery(window).scroll(function () {
            counterNumbersId.forEach(function (value, key) {
                var elementTop = jQuery('#' + value).offset().top;
                var topOfWindow = jQuery(window).scrollTop() + jQuery(window).height();
                if (elementTop < topOfWindow) {
                    counters[key].start();
                }
            });
        });

    }

};



/*-----------------------------------------------*/
/* Parallax */
/*-----------------------------------------------*/

APP.parallax = function () {

    "use strict";
    jQuery('#counterParallax').parallax('50%', 0.4, false);
    jQuery('.header-img').parallax('50%', 0.4, false);
    jQuery('#signUpNews').parallax('50%', 0.4, false);
};



/*-----------------------------------------------*/
/* Set window width */
/*-----------------------------------------------*/

APP.setWindowWidth = function () {

    "use strict";

    return document.body.clientWidth;

};



/*-----------------------------------------------*/
/* Scroll To */
/*-----------------------------------------------*/

APP.scrollto = function () {

    "use strict";

    jQuery(document).ready(function () {

        jQuery("a.scroll-to").on('click', function (e) {

            var href = jQuery(this).attr('href');
            var fixedHeight = 60;
            e.preventDefault();
            jQuery(window).scrollTo(jQuery(href).offset().top - fixedHeight, 800, {easing: 'easeInOutExpo'});

        });
    });
};


/*-----------------------------------------------*/
/* Reservation form */
/*-----------------------------------------------*/

APP.reservationForm = function () {

    "use strict";

    /* create datepicker calendar */
    if (document.getElementById("datepicker")) {

        var datepicker = jQuery("#datepicker");
        var _date = ( datepicker
            .datepicker({
                firstDay: 1,
                dateFormat: "dd mm yy",
                onSelect: function ( date ) {
                    jQuery('#reservation_date').val( date );
                }
            })
            .datepicker({dateFormat: 'yy-mm-dd'}).val());
        document.getElementById("reservation_date").value = _date;
    }

    var reservationForm = jQuery('.reservation_form');

    if ( reservationForm.length ) {

        reservationForm.each( function(){

            var form = jQuery(this);

            form.find('.btn-send').on('click', function (e) {

                var btn = jQuery(this);

                var validator = form.validate({
                    rules: {
                        reservation_first_name: 'required',
                        reservation_last_name: 'required',
                        reservation_email: {
                            required: true,
                            email: true
                        },
                        reservation_guest_number: {
                            required: true,
                            number: true
                        },
                        reservation_phone: {
                            required: true,
                        }
                    },
                    messages: {
                        reservation_first_name: pistacia_application_localize['validator_required_element'],
                        reservation_last_name: pistacia_application_localize['validator_required_element'],
                        email: {
                            required: pistacia_application_localize['validator_required_element'],
                            email: pistacia_application_localize['validator_does_not_email']
                        },
                        reservation_phone: {
                            required: pistacia_application_localize['validator_required_element']
                        },
                        reservation_guest_number: {
                            required: pistacia_application_localize['validator_required_element'],
                            number: pistacia_application_localize['validator_does_not_number']
                        }
                    }
                });

                if ( form.valid() === true && jQuery('.rsrvCode', form ).val() === '') {

                    btn.button('loading');
                    jQuery.ajax({
                        type: "POST",
                        url: pistacia_application_localize['ajax_url'],
                        data: form.serialize() + '&action=pistacia_ajaxreservation_send_mail',
                        success: function () {
                            btn.button('reset');
                            form[0].reset();
                            toastr.success( pistacia_application_localize['form_success']);
                            e.preventDefault();
                        },
                        error: function () {
                            btn.button('reset');
                        }
                    });
                } else {
                    return false;
                }
                e.preventDefault();
            });

        });


    }
};


/*-----------------------------------------------*/
/* Contact form */
/*-----------------------------------------------*/

APP.contactForm = function () {

    "use strict";
    if (document.getElementById("cntForm")) {

        var form = jQuery("#cntForm");

        form.find('.btn-send').on('click', function (e) {

            var btn = jQuery( this );

            var validator = form.validate({
                rules: {
                    contact_name: 'required',
                    contact_email: {
                        required: true,
                        email: true
                    }
                },
                messages: {
                    contact_name: pistacia_application_localize['validator_required_element'],
                    contact_email: {
                        required: pistacia_application_localize['validator_required_element'],
                        email: pistacia_application_localize['validator_does_not_email']
                    }
                }
            });

            if (form.valid() === true && jQuery('#cntCode').val() === '') {

                btn.button('loading');

                jQuery.ajax({
                    type: "post",
                    url: pistacia_application_localize['ajax_url'],
                    data: form.serialize() + '&action=pistacia_ajaxcontact_send_mail',
                    success: function (message) {
                        form[0].reset();
                        toastr.success( pistacia_application_localize['form_success']);
                        e.preventDefault();
                        btn.button('reset');
                    },
                    error: function () {
                        toastr.error( pistacia_application_localize['form_error']);
                        e.preventDefault();
                        btn.button('reset');
                    }
                });

            } else {
                return false;
            }

            e.preventDefault();

        });
    }
};



/*-----------------------------------------------*/
/* Portfolio */
/*-----------------------------------------------*/

APP.portfolio = function () {

    "use strict";

    if( document.querySelector('.portfolio-items') ) {

        var grid = null;
        jQuery('.portfolio-items').imagesLoaded(function () {
            grid = jQuery('.portfolio-items').isotope();
        });


        jQuery('.portfolio-filters').on('click', 'a', function (e) {
            e.preventDefault();
            var _this = jQuery(this);
            var _parent = _this.parent();
            var _filterValue = _this.attr('data-filter');
            grid.isotope({filter: _filterValue});
            _parent
                .addClass('active')
                .siblings()
                .removeClass('active');
        });
    }

    jQuery.fn.filteredPortfolio = function (options) {

        var elements = [];
        var filters = [];

        var init = function (jQuerycontainer) {

            proc(jQuerycontainer);

            jQuerycontainer.find(options.itemSelector).each(function () {
                elements.push(jQuery(this));
            });

            jQuerycontainer.imagesLoaded(function () {
                jQuerycontainer.masonry();
            });

        };

        var filterItems = function (selector) {
            var result = [];
            jQuery(elements).each(function (item) {
                jQuery(selector).each(function (index, sel) {
                    if (elements[item].is(sel)) {
                        if (jQuery.inArray(elements[item], result) === -1)
                            result.push(elements[item]);
                    }
                });
            });
            return result;
        };

        var reload = function (container, items) {
            container.empty();
            jQuery(items).each(function () {
                jQuery(container).append(jQuery(this));
            });
            container.masonry('reloadItems');
            container.masonry();
        };

        var hashFilter = function (container) {
            var hash = window.location.hash.replace("#", "");
            if (jQuery.inArray(hash, filters) !== -1) {
                reload(container, jQuery('.' + hash));
            }
        };

        var proc = function (container) {
            jQuery(options.filtersGroupSelector).find('input[type=checkbox]').each(function () {
                jQuery(this).change(function () {
                    var selector = [];
                    jQuery(options.filtersGroupSelector).find('input[type=checkbox]').each(function () {
                        if (jQuery(this).is(':checked')) {
                            selector.push('.' + jQuery(this).val());
                        }
                    });
                    var items = elements;
                    if (selector.length > 0) {
                        items = filterItems(selector);
                    }
                    reload(container, items);
                });
            });
        };

        return this.each(function () {
            init(jQuery(this));
        });
    };

    if( jQuery('.portfolio-items').length ){

        jQuery('.portfolio-items').filteredPortfolio({
            itemSelector: '.item',
            filtersGroupSelector: '.filters'
        });
    }

};


/*-----------------------------------------------*/
/* Google map */
/*-----------------------------------------------*/

APP.createGoogleMap = function () {

    "use strict";

    var mapElement = document.getElementById('map-canvas');

    var markers = [];
    jQuery('.marker',jQuery(mapElement)).each(function(){
        var ob = {};
        ob.lat = jQuery(this).data('lat');
        ob.lng = jQuery(this).data('lng');
        ob.text = jQuery(this).data('text');
        markers.push(ob);
    });

    if ( mapElement ) {

        +function (window, google, mapster) {

            var mapOptions = mapster.MAP_OPTIONS;
            mapster.MAP_OPTIONS.styles = [ { "featureType": "administrative", "elementType": "geometry", "stylers": [ { "hue": "#ff0000" } ] }, { "featureType": "administrative", "elementType": "labels.text.fill", "stylers": [ { "color": "#444444" } ] }, { "featureType": "landscape", "elementType": "all", "stylers": [ { "color": "#f2f2f2" } ] }, { "featureType": "landscape.man_made", "elementType": "geometry", "stylers": [ { "hue": "#ff0000" } ] }, { "featureType": "poi", "elementType": "all", "stylers": [ { "visibility": "off" } ] }, { "featureType": "poi.business", "elementType": "all", "stylers": [ { "visibility": "on" }, { "hue": "#00ffed" }, { "saturation": "2" }, { "lightness": "4" }, { "weight": "2.07" } ] }, { "featureType": "road", "elementType": "all", "stylers": [ { "saturation": -100 }, { "lightness": 45 } ] }, { "featureType": "road.highway", "elementType": "all", "stylers": [ { "visibility": "simplified" } ] }, { "featureType": "road.arterial", "elementType": "labels.icon", "stylers": [ { "visibility": "off" } ] }, { "featureType": "transit", "elementType": "all", "stylers": [ { "visibility": "off" } ] }, { "featureType": "water", "elementType": "all", "stylers": [ { "color": "#46bcec" }, { "visibility": "on" } ] } ];

            if ( jQuery(mapElement).data('lat') && jQuery(mapElement).data('lng') && jQuery(mapElement).data('zoom') ){
                mapster.MAP_OPTIONS.center.lat = parseFloat(jQuery(mapElement).data('lat'));
                mapster.MAP_OPTIONS.center.lng = parseFloat(jQuery(mapElement).data('lng'));
                mapster.MAP_OPTIONS.zoom = parseInt(jQuery(mapElement).data('zoom'));

                if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
                    mapster.MAP_OPTIONS.draggable = false;
                }

                var map = mapster.create(mapElement, mapOptions);

                if( markers ) {
                    markers.forEach(function ( marker ) {
                        map.addMarker({
                            position: {
                                lat: parseFloat(marker.lat),
                                lng: parseFloat(marker.lng)
                            },
                            event: {
                                name: 'click',
                                callback: function () {
                                }
                            },
                            content: '<div class="marker-text" style="width:200px">'+ marker.text +'</div>',
                            contentShow: false,
                            id: 1,
                            draggable: false,
                            icon: pistacia_application_localize['stylesheet_directory'] + '/assets/img/map.png'
                        });
                    });
                }
            }

        }(window, google, window.Mapster || (window.Mapster = {}));
    }
};


/*-----------------------------------------------*/
/* plax parallax layers */
/*-----------------------------------------------*/

APP.plax = function () {

    "use strict";

    if( document.getElementById('page404') ) {

        jQuery('#page404 #layer-1').plaxify({
            "xRange": 0,
            "yRange": 0
        });
        jQuery('#psge404 #layer-2').plaxify({
            "xRange": 20,
            "yRange": 20
        });
        jQuery('#page404 #layer-3').plaxify({
            "xRange": 40,
            "yRange": 40
        });
        jQuery('#page404 #layer-5').plaxify({
            "xRange": 50,
            "yRange": 50
        });
        jQuery('#page404 #layer-6').plaxify({
            "xRange": 110,
            "yRange": 20
        });
        jQuery('#page404 #layer-7').plaxify({
            "xRange": 140,
            "yRange": 70
        });
        jQuery('#page404 #layer-8').plaxify({
            "xRange": 320,
            "yRange": 120
        });
        jQuery('#page404 #layer-9').plaxify({
            "xRange": 40,
            "yRange": 0
        });
        jQuery.plax.enable({
            clearLayers: true,
            restorePositions: true,
            activityTarget: jQuery('.plax-wrapper')
        });
    }
};


/*-----------------------------------------------*/
/* Flexslider */
/*-----------------------------------------------*/

APP.flexSlider = function () {

    "use strict";

    if(document.querySelector('.shop-item-carousel')) {
        jQuery(window).load(function() {
            jQuery('#shop-item-carousel').flexslider({
                animation: "fade",
                controlNav: false,
                animationLoop: false,
                directionNav: false,
                slideshow: false,
                sync: "#shop-item-carousel-nav"
            });
            jQuery('#shop-item-carousel-nav').flexslider({
                animation: "slide",
                controlNav: false,
                directionNav: true,
                animationLoop: false,
                slideshow: false,
                itemWidth: 130,
                itemMargin: 5,
                asNavFor: '#shop-item-carousel'
            });
        });
    }
};


/*-----------------------------------------------*/
/* Top menu */
/*-----------------------------------------------*/

APP.hovermenu = function () {

    "use strict";

    jQuery('.top-menu li').each(function () {
        var that = jQuery(this);
        if (that.has('ul').length > 0) {
            jQuery(this).find('>ul').addClass('sub-menu');
            jQuery(this).find('>a').addClass('trigger');
            that.find('>a').on("click", function (e) {
                e.preventDefault();
            });
        }
    });

    jQuery(".dropdown-menu > li > a.trigger").on("click",function(e){
        var current=jQuery(this).next();
        var grandparent=jQuery(this).parent().parent();
        grandparent.find(".sub-menu:visible").not(current).hide();
        current.toggle();
        e.stopPropagation();
    });
    jQuery(".dropdown-menu > li > a:not(.trigger)").on("click",function(){
        var root=jQuery(this).closest('.dropdown');
        root.find('.left-caret').toggleClass('right-caret left-caret');
        root.find('.sub-menu:visible').hide();
    });

};



/*-----------------------------------------------*/
/* Animate element if appeared */
/*-----------------------------------------------*/

APP.animateElementIfAppear = function () {

    "use strict";
    jQuery(window).scroll(function () {

        jQuery('[class$=-ifAppeared]').each(function () {

            var elementTop = jQuery(this).offset().top;
            var topOfWindow = jQuery(window).scrollTop() + jQuery(window).height() - 300;
            var classes = jQuery(this).attr("class").split(' ');
            var animateClass = '';
            jQuery.each(classes, function (index, item) {
                var a = item.split('-');
                if (a[1] == 'ifAppeared') {
                    animateClass = a[0];
                }
            });
            if (elementTop < topOfWindow) {
                jQuery(this).addClass("animated " + animateClass);
            }

        });
    });
};



/*-----------------------------------------------*/
/* Sticky navigation */
/*-----------------------------------------------*/

APP.stickynav = function () {

    var element = jQuery('#pistacia-top-navigation');

    if ( element.length ) {

        var sticky_navigation_offset_top = element.offset().top;

        var sticky_navigation = function () {
            var scroll_top = jQuery(window).scrollTop();
            if (scroll_top > sticky_navigation_offset_top) {
                element.parent().addClass('sticky-on');
            } else {
                element.parent().removeClass('sticky-on');
            }
        };

        sticky_navigation();

        jQuery(window).scroll(sticky_navigation);
        jQuery(window).resize(sticky_navigation);

    }
};



/*-----------------------------------------------*/
/* Bootstrap functions */
/*-----------------------------------------------*/

APP.bootstrap = function () {

    "use strict";

    /* Bootstrap windows phone hack */
    if (navigator.userAgent.match(/IEMobile\/10\.0/)) {
        var msViewportStyle = document.createElement('style');
        msViewportStyle.appendChild(
            document.createTextNode(
                '@-ms-viewport{width:auto!important}'
            )
        );
        document.querySelector('head').appendChild(msViewportStyle);
    }

    jQuery("body").tooltip({
        selector: '[data-toggle="tooltip"]',
        trigger : 'hover'
    });

    jQuery('.wp-tab-content .nav-tabs a').click(function (e) {
        e.preventDefault();
        jQuery(this).tab('show');
    });

    jQuery('.panel-heading a').click(function() {
        jQuery('.panel-heading').removeClass('active');
        jQuery(this).parents('.panel-heading').addClass('active');
    });

};



/*-----------------------------------------------*/
/* Page preloader */
/*-----------------------------------------------*/

APP.pageloader = function () {

    "use strict";
    jQuery(document).imagesLoaded(function () {
        jQuery('.page-loader')
            .delay(100)
            .fadeOut(500);
    });
};



/*-----------------------------------------------*/
/* Run application */
/*-----------------------------------------------*/
APP.init();