<?php /**
 * archive.php
 *
 * This file contains archives
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
get_header(); ?>

<?php if ( have_posts() ) : ?>

    <?php $aside = ( is_active_sidebar( 'pistacia_blog_sb' ) ) ? true : false; ?>

    <section class="single-post">

        <div class="container">

            <div class="col-md-<?php echo $aside ? '8' : '12'; ?>">

                <?php while( have_posts() ) : the_post(); ?>

                    <?php get_template_part('partials/format'); ?>

                <?php endwhile; ?>

                <div class="text-center paginator-wrapper">

                    <?php the_posts_pagination( array(
                        'mid_size'  => 2,
                        'prev_text' => esc_html__( 'Previous', 'pistacia' ),
                        'next_text' => esc_html__( 'Forward', 'pistacia' ) ));?>

                </div>

            </div>

            <?php if ( $aside ) : ?>
                <div class="col-md-4 pistacia-aside">
                    <?php dynamic_sidebar( 'pistacia_blog_sb' ); ?>
                </div>
            <?php endif; ?>

        </div>

    </section>

<?php endif; ?>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer(); ?>