<?php
/**
 * ps_bldr_welcomeheader.php
 *
 * This file contains welcome header slider and food items
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>
<?php if ( get_sub_field('ps_bldr_wlcm_items') ){
    $rows = get_sub_field('ps_bldr_wlcm_items');
} ?>

<?php if ( !empty($rows) ): ?>

    <header class="header welcome-header-wrapper">
        <div class="welcome-header" id="welcomeHeader">
            <div class="overlay overlay-black-40"></div>
            <div class="welcome-img-slider">
                <ul class="slides clearfix">
                    <?php foreach($rows as $item) : ?>
                        <li style="background-image:url('<?php echo esc_url($item['pistacia_wlcm_item_limage']['url']); ?>');"></li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <div class="welcome-inner">
                <div class="container">
                    <div class="text-slider welcome-flexslider">
                        <ul class="slides">
                            <?php foreach($rows as $item) : ?>
                                <li class="text-center"><?php echo esc_html($item['pistacia_wlcm_item_icontxt']);?> <span class="extra-bold"><?php echo esc_html($item['pistacia_wlcm_item_title']);?></span></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="text-center">
                        <a href=".scrollinghere" class="btn btn-transparent hvr-shutter-out-horizontal scroll-to center-block">More</a>
                    </div>
                    <div role="tabpanel" class="quickcategories clearfix">
                        <ul class="nav nav-tabs" role="tablist">
                            <?php $count = 0; ?>
                            <?php foreach($rows as $item) : ?>
                                <li role="presentation"<?php echo ( $count == 0 ? ' class="active"' : '');?>>
                                    <a href="#tabpanel-<?php echo $count; ?>" aria-controls="tabpanel-<?php echo $count; ?>" role="tab" data-toggle="tab" class="flexslider-to" data-flexslide="<?php echo $count; ?>">
                                        <?php if ( !empty($item['pistacia_wlcm_item_icon']) ) : ?>
                                            <i class="flaticon <?php echo esc_html( $item['pistacia_wlcm_item_icon'] ); ?>"></i>
                                        <?php endif; ?>
                                        <?php if(!empty($item['pistacia_wlcm_item_icontxt'])):?>
                                            <span class="hidden-xs"><?php echo esc_html($item['pistacia_wlcm_item_icontxt']);?></span>
                                        <?php endif; ?>
                                    </a>
                                </li>
                                <?php $count++; ?>
                            <?php endforeach; ?>
                        </ul>
                        <div class="tab-content ">
                            <?php $count = 0; ?>
                            <?php foreach($rows as $item) : ?>
                                <div role="tabpanel" class="tab-pane fade<?php if( $count == 0 ){ echo ' active in'; } ?>" id="tabpanel-<?php echo $count; ?>">
                                    <div class="row">
                                        <div class="col-xs-5">
                                            <?php if ( !empty( $item['pistacia_wlcm_item_link']) ){ echo '<a href="'.esc_url($item['pistacia_wlcm_item_link']).'">'; } ?>
                                            <?php if ( !empty( $item['pistacia_wlcm_item_simage']['url'] ) ):?>
                                                <img src="<?php echo esc_url($item['pistacia_wlcm_item_simage']['url']); ?>" class="img-responsive" alt="">
                                            <?php endif; ?>
                                            <?php if ( !empty( $item['pistacia_wlcm_item_link']) ){ echo '</a>'; } ?>
                                        </div>
                                        <div class="col-xs-7">
                                            <?php if ( !empty( $item['pistacia_wlcm_item_title']) ):?>
                                                <h3><?php echo esc_html($item['pistacia_wlcm_item_title']);?></h3>
                                            <?php endif; ?>
                                            <?php if ( !empty( $item['pistacia_wlcm_item_excerpt']) ):?>
                                                <p><?php echo esc_html($item['pistacia_wlcm_item_excerpt']);?></p>
                                            <?php endif; ?>

                                            <?php if ( !empty( $item['pistacia_wlcm_item_price']) ):?>
                                                <span class="label label-danger label-lg price-label"><?php echo esc_html($item['pistacia_wlcm_item_price']);?></span>
                                            <?php endif; ?>
                                            <?php if ( !empty( $item['pistacia_wlcm_item_link']) ):?>
                                                <a class="more-btn" href="<?php echo esc_url($item['pistacia_wlcm_item_link']);?>"><i class="fa fa-chevron-right"></i> <?php esc_html_e('More','pistacia');?></a>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                                <?php $count++; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
<?php endif; ?>

    <div class="scrollinghere"></div>

<?php $autoplay = get_sub_field('pistacia_wlcm_autoplay'); ?>

<?php if ( ( $autoplay ) && ($autoplay != 0 )) : ?>
    <script>
        (function() {
            jQuery(document).ready(function () {

                var tabCarousel = '';
                var tabs = jQuery('.quickcategories .nav-tabs > li');

                function startCarousel() {
                    tabCarousel = setInterval(function () {
                        var active = tabs.filter('.active');
                        var next = active.next('li').length? active.next('li').find('a') : tabs.filter(':first-child').find('a');
                        next.trigger('click');
                    }, <?php echo esc_html( $autoplay );?>);
                }

                if(document.querySelector('.welcome-img-slider')) {
                    jQuery('.welcome-img-slider').flexslider({
                        animation: "fade",
                        controlNav: false,
                        directionNav: false,
                        touch: true,
                        slideshow: false,
                        startAt: 0,
                        direction: "horizontal"
                    });
                }

                if (jQuery('.text-slider').length){
                    jQuery('.text-slider').flexslider({
                        animation: "slide",
                        controlNav: false,
                        directionNav: false,
                        touch: true,
                        slideshow: false,
                        direction: "vertical"
                    });
                }

                if(document.querySelector('.flexslider-to')) {
                    jQuery('.flexslider-to').on('click', function () {
                        if (document.querySelector('.welcome-img-slider')) {
                            jQuery('.welcome-img-slider').flexslider(jQuery(this).data('flexslide'));
                        }
                    });
                }

                if(document.querySelector('.flexslider-to')) {
                    jQuery('.flexslider-to').on('click', function () {
                        if (document.querySelector('.welcome-img-slider')) {
                            jQuery('.welcome-img-slider').flexslider(jQuery(this).data('flexslide'));
                            jQuery('.text-slider').flexslider(jQuery(this).data('flexslide'));
                        }
                    });
                }

                jQuery('.quickcategories .nav-tabs li a').on('mouseover', function () {
                    clearInterval(tabCarousel);
                });

                jQuery('.quickcategories .nav-tabs li a').on('mouseleave', function () {
                    startCarousel();
                });

                jQuery('#top-menu-collapse').on('show.bs.collapse', function () {
                    clearInterval(tabCarousel);
                });

                jQuery('#top-menu-collapse').on('hide.bs.collapse', function () {
                    startCarousel();
                });

                startCarousel();

            });
        })();
    </script>
<?php endif; ?>