<?php
/**
 * ps_bldr_video_block.php
 *
 * This file contains video block
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */
?>

<?php switch ( get_sub_field('pistacia_vdblck_layout') ){
    case 'ps_text_top' :
        $text_css = 'col-md-12 fadeInDown-ifAppeared';
        $video_css = 'col-md-12 fadeInUp-ifAppeared';
        break;
    case 'ps_text_left' :
        $text_css = 'col-md-6 fadeInLeft-ifAppeared';
        $video_css = 'col-md-6 fadeInRight-ifAppeared';
        break;
    case 'ps_text_right' :
        $text_css = 'col-md-6 col-md-push-6 fadeInRight-ifAppeared';
        $video_css = 'col-md-6 col-md-pull-6 fadeInLeft-ifAppeared';
        break;
} ?>

<?php $title_light = get_sub_field('pistacia_vdblck_titlelight'); ?>
<?php $title_bold = get_sub_field('pistacia_vdblck_titlebold'); ?>
<?php $excerpt = get_sub_field('pistacia_vdblck_excerpt'); ?>

<section class="video-block-section <?php the_sub_field('pistacia_vdblck_layout');?>" id="video-block-section">

    <div class="container">

        <div class="<?php echo esc_attr($text_css); ?>">

            <?php if ( $title_light || $title_bold ) : ?>

                <h1 class="text-center">

                    <?php if ( $title_light ) : ?>
                        <span class="light"><?php echo esc_html( $title_light );?></span>
                    <?php endif; ?>

                    <?php if ( $title_bold ) : ?>
                        <span class="extra-bold"><?php echo esc_html( $title_bold );?></span>
                    <?php endif; ?>

                </h1>

                <div class="zigzag"><i class="<?php echo esc_html( get_sub_field('pistacia_vdblck_icon') );?>"></i></div>

            <?php endif; ?>


            <?php if ( $excerpt ) : ?>

                <div class="text-center">

                    <p class="text-center lead"><?php echo esc_html( $excerpt );?></p>

                </div>

            <?php endif; ?>

        </div>

        <div class="<?php echo esc_attr($video_css); ?>">
            <div class="embed-responsive post-video embed-responsive-16by9">
                <?php the_sub_field('ps_bldr_vdblck_video');?>
            </div>
        </div>

    </div>

</section>
