<?php
/**
 * ps_bldr_specialties.php
 *
 * This file contains chef specialties and reservation form
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php $title_light = get_sub_field('pistacia_spclts_titlelight'); ?>
<?php $title_bold = get_sub_field('pistacia_spclts_titlebold'); ?>
<?php $excerpt = get_sub_field('pistacia_spclts_excerpt'); ?>

<section class="specialties" id="specialties">

    <div class="container">

        <div class="specialties-wrapper">

            <div class="left-photo">

                <div class="inner">

                    <?php $img = get_sub_field('pistacia_spclts_image');?>
                    <?php if ( !empty($img) ) : ?>
                        <img src="<?php echo esc_url( $img['url'] ); ?>" class="img-responsive" alt="<?php echo esc_html( $img['alt'] );?>">
                    <?php endif; ?>

                </div>

            </div>

            <div class="right-text">

                <div class="inner">

                    <?php if ( $title_light ) : ?>
                        <h1 class="text-center"><?php echo esc_html( $title_light );?>
                        <?php if ( $title_bold ) : ?>
                            <span class="extra-bold"><?php echo esc_html( $title_bold );?></span></h1>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if ( $excerpt ) : ?>
                        <p class="text-center">
                            <?php echo esc_html( $excerpt ); ?>
                        </p>
                    <?php endif; ?>

                    <div class="zigzag"><i class="flaticon flaticon-covered16"></i></div>

                    <?php if( have_rows('ps_bldr_spclts_items') ) : ?>

                        <div class="row">

                            <?php while ( have_rows( 'ps_bldr_spclts_items' ) ) : the_row(); ?>

                                <?php $icon = get_sub_field( 'pistacia_spclts_item_icon' ); ?>
                                <?php $title = get_sub_field( 'pistacia_spclts_item_title' ); ?>
                                <?php $price = get_sub_field( 'pistacia_spclts_item_price' ); ?>

                                <div class="card effect__hover col-sm-4">
                                    <div class="card__front">
                                        <div class="content text-center">
                                            <?php if ( $icon ) : ?>
                                                <i class="flaticon <?php echo esc_html( $icon );?>"></i>
                                            <?php endif; ?>

                                            <?php if ( $title ) : ?>
                                                <h4 class="padding-bottom-5 padding-top-5"><?php echo esc_html( $title ); ?></h4>
                                            <?php endif; ?>

                                            <?php if ( $price ) : ?>
                                                <span class="label label-success label-lg"><?php echo esc_html( $price ); ?></span>
                                            <?php endif; ?>

                                        </div>
                                    </div>

                                    <?php $photo = get_sub_field( 'pistacia_spclts_item_photo' ); ?>
                                    <?php if ( !empty($photo) ) : ?>
                                        <div class="card__back" style="background-image:url('<?php echo esc_url( $photo['sizes']['medium'] );?>');">
                                            <div class="content text-center"></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endwhile; ?>

                        </div>
                        
                    <?php endif; ?>

                </div>

            </div>

        </div>

    </div>

</section>

<section class="reservation-section">

    <div id="reservation">

        <div class="overlay overlay-black-90"></div>

        <?php $decorphoto = get_sub_field( 'pistacia_spclts_dimage' ); ?>

        <?php if ( !empty( $decorphoto ) ) : ?>
            <div class="plate"><img src="<?php echo esc_url( $decorphoto['url'] );?>" class="img-responsive" alt="<?php echo esc_url( $decorphoto['alt'] );?>"></div>
        <?php else : ?>
            <div class="plate"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/img/decor.png" alt=""></div>
        <?php endif; ?>

        <div class="container container-inner">

            <?php Pistacia_Ajax_Forms::the_reservation_form(array(
                'calendar_hide' => (get_sub_field('pistacia_spclts_calendar')) ? true : false,
                'reservation_times' => get_sub_field('pistacia_spclts_hours')
            )); ?>

        </div>

    </div>

</section>