<?php
/**
 * ps_bldr_services_blocks.php
 *
 * This file contains services blocks
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php $title_light = get_sub_field('ps_srvcblck_title_l'); ?>
<?php $title_bold = get_sub_field('ps_srvcblck_title_b'); ?>
<?php $excerpt = get_sub_field('ps_srvcblck_excerpt'); ?>

<section class="services" id="services">

    <div class="container">

        <?php if ( $title_light || $title_bold ) : ?>

            <h1 class="text-center">

                <?php if ( $title_light ) : ?>
                    <span class="light"><?php echo esc_html( $title_light );?></span>
                <?php endif; ?>

                <?php if ( $title_bold ) : ?>
                    <span class="extra-bold"><?php echo esc_html( $title_bold );?></span>
                <?php endif; ?>

            </h1>

            <div class="zigzag"><i class="<?php echo esc_html( get_sub_field('ps_srvcblck_icon') );?>"></i></div>

        <?php endif; ?>


        <?php if ( $excerpt ) : ?>

            <div class="row">

                <div class="col-md-offset-3 col-md-6">

                    <p class="text-center lead"><?php echo esc_html( $excerpt );?></p>

                </div>

            </div>

        <?php endif; ?>

        <?php $items = get_sub_field('ps_srvcblck_items'); ?>

        <?php if( $items ) : ?>

            <div class="services-items">

                <?php foreach( $items as $item ) : ?>

                    <div class="col-md-4 item">
                        <i class="icon-circle gray-bg <?php echo esc_html( $item['ps_srvcblck_icon'] ); ?>"></i>
                        <h3 class="text-center"><?php echo esc_html( $item['ps_srvcblck_title'] ); ?></h3>
                        <p class="text-center"><?php echo esc_html( $item['ps_srvcblck_excerpt'] ); ?></p>
                    </div>

                <?php endforeach; ?>

            </div>

        <?php endif; ?>

    </div>

</section>
