<?php
/**
 * ps_bldr_service_carousel.php
 *
 * This file contains service carousels
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php $title_light = get_sub_field( 'ps_srvccrs_title_l' ); ?>
<?php $title_bold = get_sub_field( 'ps_srvccrs_title_b' ); ?>
<?php $excerpt = get_sub_field( 'ps_srvccrs_excerpt' ); ?>

<section class="we-can-offer" id="weCanOffer">

    <div class="container">

        <div class="row">

            <?php if ( $title_light || $title_bold || $excerpt ) : ?>

                <?php $has_left = true; ?>

                <div class="col-md-6">

                    <?php if ( $title_light  || $title_bold ) : ?>
                        <h1 class="text-center">
                            <?php if ( $title_light ) : ?>
                                <span class="light"><?php echo esc_html( $title_light ); ?></span>
                            <?php endif; ?>
                            <?php if ( $title_bold ) : ?>
                                <span class="extra-bold"><?php echo esc_html( $title_bold ); ?></span>
                            <?php endif; ?>
                        </h1>
                    <?php endif; ?>

                    <div class="zigzag"><i class="<?php echo esc_html( get_sub_field('ps_srvccrs_icon') );?>"></i></div>

                    <?php if ( $excerpt ) : ?>
                        <p class="lead text-center"><?php echo esc_html( $excerpt ); ?></p>
                    <?php endif; ?>

                </div>

            <?php else : $has_left = false; ?>

            <?php endif; ?>

            <div class="col-md-<?php echo ( $has_left ) ? '6' : '12'; ?>">

                <div class="offer-owl-carousel">

                    <?php $carousels = get_sub_field( 'ps_srvccrs_carousels' );?>

                    <?php if ( $carousels ) : ?>

                        <div class="swiper-container services-carousels-swiper-container">

                            <div class="swiper-wrapper">

                                <?php foreach( $carousels as $item ) : ?>

                                    <div class="item swiper-slide">

                                        <h3>
                                            <?php if ( !empty( $item['ps_srvccrsc_icon'] ) ) : ?>
                                                <i class="flaticon-circle flaticon-dark <?php echo esc_html( $item['ps_srvccrsc_icon'] ); ?>"></i>
                                            <?php endif; ?>
                                            <?php echo esc_html( $item['ps_srvccrsc_title'] ); ?>
                                        </h3>

                                        <p><?php echo esc_html( $item['ps_srvccrsc_excerpt'] ); ?></p>

                                        <?php if ( !empty( $item['ps_srvccrsc_link'] ) ) : ?>
                                            <a href="<?php echo esc_html($item['ps_srvccrsc_link']); ?>" class="btn-more hvr-icon-forward"><?php esc_html_e('More', 'pistacia'); ?></a>
                                        <?php endif; ?>
                                    </div>

                                <?php endforeach; ?>

                            </div>

                            <?php if ( count( $carousels ) > 2 ) : ?>
                                    <div class="services_carousels-swiper-button-next"><i class="fa fa-angle-right"></i></div>
                                    <div class="services_carousels-swiper-button-prev"><i class="fa fa-angle-left"></i></div>
                            <?php endif; ?>

                        </div>

                    <?php endif; ?>

                </div>

            </div>

        </div>

    </div>

</section>