<?php
/**
 * ps_bldr_recipes_slider.php
 *
 * This file contains recipe slider
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */
?>

<?php global $pistacia_recipe_manager; ?>

<?php if ( !empty($pistacia_recipe_manager) ) : ?>

    <?php $args = array(
        'post_type' => 'pistacia-recipes',
        'posts_per_page' => (get_sub_field('ps_rcpssldr_perpage') ) ? get_sub_field('ps_rcpssldr_perpage') : '5',
        'orderby' => (get_sub_field('ps_rcpssldr_orderby') ) ? get_sub_field('ps_rcpssldr_orderby') : 'date',
        'order'   => (get_sub_field('ps_rcpssldr_sorting') ) ? get_sub_field('ps_rcpssldr_sorting') : 'DESC',
    );?>

    <?php $loop = new WP_Query( $args ); ?>

    <?php if( $loop->have_posts() ) : ?>

        <?php $type = get_sub_field('ps_rcpssldr_type'); ?>

        <?php if ( $type == 'header' ) : ?>

            <?php $section_bg = get_sub_field('ps_rcpssldr_section_bg'); ?>

            <section class="recipes-slider-section"
                     <?php if ( $section_bg ) : ?>style="background-image:url('<?php echo esc_url( $section_bg );?>');" <?php endif; ?>>
                <div class="recipes-slider-section-inner">
                    <div class="container">
                        <div class="recipe-slider-wrapper">
                            <div class="swiper-container recipes-header-swiper-container">

                                <div class="swiper-wrapper">

                                    <?php while( $loop->have_posts() ) : $loop->the_post(); ?>

                                        <?php $photo_src = wp_get_attachment_image_src(get_post_thumbnail_id( $loop->get_the_ID() ), 'large'); ?>
                                        <?php $author_photo = get_field('pistacia_recipe_author_photo'); ?>
                                        <?php $author_name = get_field('pistacia_recipe_author'); ?>
                                        <?php $skills = get_field('pistacia_recipe_skill'); ?>

                                        <div class="swiper-slide">
                                            <div class="recipe-slide-wrapper">
                                                <div class="recipe-photo" style="background-image:url('<?php echo esc_url($photo_src[0]);?>');"></div>
                                                <div class="recipe-content">
                                                    <div class="recipe-content-inner">

                                                        <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>

                                                        <div class="clearfix">
                                                            <?php if ( $author_photo ) : ?>
                                                                <img src="<?php echo esc_url( $author_photo['sizes']['thumbnail'] ); ?>" class="recipe-author-photo img-responsive img-circle" alt="">
                                                            <?php endif; ?>
                                                            <?php if ( $author_name ) : ?>
                                                                <span class="recipe-author-name"><?php esc_html_e('by','pistacia');?>: <?php echo esc_html( $author_name ); ?></span>
                                                            <?php endif; ?>
                                                        </div>

                                                        <div class="excerpt"><?php the_excerpt();?></div>

                                                        <?php if ( $skills ) : ?>
                                                            <div class="difficulty">
                                                                <?php esc_html_e('Difficulty','pistacia');?>:
                                                                <?php for( $a=1; $a<= 5; $a++ ) : ?>
                                                                    <i class="flaticon-meal2<?php echo ( $a <= (int)$skills ) ? ' active' : ''; ?>"></i>
                                                                <?php endfor; ?>
                                                            </div>
                                                        <?php endif; ?>

                                                        <a href="<?php the_permalink();?>" class="btn btn-more"><?php esc_html_e('More','pistacia');?></a>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    <?php endwhile; ?>

                                </div>

                                <?php if ( $loop->post_count > 1 ) : ?>
                                    <div class="recipes-header-swiper-button-prev"><i class="fa fa-angle-left"></i></div>
                                    <div class="recipes-header-swiper-button-next"><i class="fa fa-angle-right"></i></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php endif; ?>

    <?php endif; ?>

    <?php wp_reset_postdata(); ?>

<?php endif; ?>
