<?php
/**
 * ps_bldr_quotecarousel.php
 *
 * This file contains quote carousels
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php $img_src = get_sub_field('pistacia_qtcrsl_image'); ?>
<?php $title_light = get_sub_field('ps_qtcrsl_title_l'); ?>
<?php $title_bold = get_sub_field('ps_qtcrsl_title_b'); ?>


<section class="quote-carousel-section" style="background-image:url('<?php if ( $img_src ) { echo esc_url( $img_src ); }?>');">
    <div class="overlay overlay-black-70"></div>
    <div class="container-inner">
        <div class="container">

            <?php if ( $title_light || $title_bold ) : ?>
                <div class="row">
                    <div class="col-md-6 col-md-push-3">

                        <h1 class="text-center section-title">
                            <?php if ( $title_light ) : ?>
                                <span class="light"><?php echo esc_html( $title_light );?></span>
                            <?php endif; ?>
                            <?php if ( $title_bold ) : ?>
                                <span class="extra-bold"><?php echo esc_html( $title_bold );?></span>
                            <?php endif; ?>
                        </h1>
                    </div>
                </div>
            <?php endif; ?>

            <?php $testimonals = ( get_sub_field('pistacia_qtcrsl_items') );?>
            <?php if ( $testimonals ) : ?>
                <div class="testimonal-swiper-container swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach ( $testimonals as $item ) : ?>
                            <div class="swiper-slide">
                                <p class="testimonal-text text-center"><?php echo esc_html( $item['ps_qtcrsl_q_text'] );?></p>
                                <div class="text-center">
                                    <span class="testimonal-name text-center"><?php echo esc_html( $item['ps_qtcrsl_q_name'] );?></span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?php if ( count($testimonals) > 1 ) : ?>
                        <div class="swiper-pagination testimonal-swiper-pagination"></div>
                    <?php endif; ?>

                </div>
            <?php endif; ?>

        </div>
    </div>
</section>
