<?php
/**
 * ps_bldr_menucards.php
 *
 * This file contains menu cards
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php $title_light = get_sub_field('ps_mncrds_title_l'); ?>
<?php $title_bold = get_sub_field('ps_mncrds_title_b'); ?>
<?php $excerpt = get_sub_field('ps_mncrds_excerpt'); ?>
<?php $items = get_sub_field( 'ps_bldr_mncrds_items' ); ?>

<section class="menu-cards" id="menuCards">

    <?php if( $title_light || $title_bold || $excerpt ) : ?>

        <div class="container card-section-text">

            <h1 class="text-center">

                <?php if ( $title_light ) : ?>
                    <span class="light"><?php echo esc_html( $title_light );?></span>
                <?php endif; ?>

                <?php if ( $title_bold ) : ?>
                    <span class="extra-bold"><?php echo esc_html( $title_bold );?></span>
                <?php endif; ?>

            </h1>

            <div class="zigzag"><i class="<?php echo esc_html( get_sub_field('ps_mncrds_icon') );?>"></i></div>

            <div class="row">

                <div class="col-md-offset-3 col-md-6">

                    <?php if ( $excerpt ) : ?>

                        <p class="text-center lead"><?php echo esc_html( $excerpt );?></p>

                    <?php endif; ?>

                </div>

            </div>

        </div>

    <?php endif; ?>

    <div class="container">

        <div class="menucard-boxes">

            <?php if ( $items ) : ?>

                <?php foreach ( $items as $item ) : ?>

                    <div class="menucard-box item hvr-float-shadow">

                        <div class="container-inner clearfix">

                            <div class="row">

                                <div class="col-md-4">
                                    <figure>
                                        <?php $img = $item['pistacia_mncrds_item_photo'];?>
                                        <?php if ( $img ) : ?>
                                            <img src="<?php echo esc_url($img['sizes']['thumbnail']);?>" class="img-responsive" alt="<?php echo esc_html($img['alt']);?>">
                                        <?php endif; ?>
                                    </figure>

                                </div>

                                <div class="col-md-8">

                                    <div class="item-detail">

                                        <h4 class="product-name">
                                            <a href="<?php echo esc_url($item['pistacia_mncrds_item_link']); ?>">
                                                <?php echo esc_html($item['pistacia_mncrds_item_title']);?>
                                            </a>
                                        </h4>

                                        <p><?php echo esc_html($item['pistacia_mncrds_item_excerpt']);?></p>

                                        <?php pistacia_the_stars( $item['pistacia_mncrds_item_stars'] ); ?>

                                    </div>

                                </div>

                            </div>

                            <div class="row">

                                <div class="col-md-12">

                                    <a href="<?php echo esc_url($item['pistacia_mncrds_item_link']); ?>" class="btn btn-primary">
                                        <?php echo esc_html($item['pistacia_mncrds_item_price']);?>
                                    </a>

                                </div>

                            </div>

                        </div>

                    </div>

                <?php endforeach; ?>

            <?php endif; ?>

        </div>

    </div>

</section>
