<?php
/**
 * ps_bldr_logoslider_link.php
 *
 * This file contains logo slider width external link
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */
?>
<?php $gallery = get_sub_field( 'ps_lg_sldrl_items' );?>

<?php if ( !empty( $gallery ) ) : ?>

    <section class="loc-wrapper" id="locWrapper">

        <div class="container<?php if ( get_sub_field( 'ps_lg_sldrl_fullwidth' ) == 1 ) { echo '-fluid'; } ?>">

            <div class="swiper-container logo-swiper-container">

                <div class="swiper-wrapper">

                    <?php foreach ( $gallery as $item ) : ?>
                        <div class="swiper-slide">
                            <a href="<?php echo esc_url($item['pistacia_sldrl_item_link']);?>">
                                <img src="<?php echo esc_url($item['pistacia_sldrl_item_photo']['url']);?>" class="img-responsive" alt="<?php echo esc_attr($item['pistacia_sldrl_item_photo']['alt']);?>">
                            </a>
                        </div>
                    <?php endforeach; ?>

                </div>

                <?php if ( count($gallery) > 6 ) : ?>
                    <div class="text-center">
                        <div class="logo-swiper-button-prev"><i class="fa fa-angle-left"></i></div>
                        <div class="logo-swiper-button-next"><i class="fa fa-angle-right"></i></div>
                    </div>
                <?php endif; ?>

            </div>

        </div>

    </section>

<?php endif; ?>
