<?php
/**
 * ps_bldr_logoslider.php
 *
 * This file contains logo slider
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>
<?php $gallery = get_sub_field( 'ps_lg_sldr_items' );?>

<?php if ( !empty( $gallery ) ) : ?>

    <section class="loc-wrapper" id="locWrapper">

        <div class="container<?php if (get_sub_field( 'ps_lg_sldr_fullwidth' ) == 1) { echo '-fluid'; } ?>">

            <div class="swiper-container logo-swiper-container">

                <div class="swiper-wrapper">

                    <?php foreach ( $gallery as $item ) : ?>
                        <div class="swiper-slide">
                            <img src="<?php echo esc_url($item['url']);?>" class="img-responsive" alt="<?php echo esc_attr($item['alt']);?>">
                        </div>
                    <?php endforeach; ?>

                </div>

                <?php if ( count($gallery) > 6 ) : ?>
                <div class="text-center">
                    <div class="logo-swiper-button-prev"><i class="fa fa-angle-left"></i></div>
                    <div class="logo-swiper-button-next"><i class="fa fa-angle-right"></i></div>
                </div>
                <?php endif; ?>

            </div>

        </div>

    </section>

<?php endif; ?>

