<?php
/**
 * ps_bldr_latestposts.php
 *
 * This file contains latest posts
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php $title_light = get_sub_field('ps_ltstpsts_title_l'); ?>
<?php $title_bold = get_sub_field('ps_ltstpsts_title_b'); ?>
<?php $excerpt = get_sub_field('ps_ltstpsts_excerpt'); ?>


<section class="isotope-posts-section pinterest-blog" id="isotope-blog">

    <div class="isotope-posts-section-inner">

        <div class="container">

            <?php if ( $title_light || $title_bold ) : ?>

                <h1 class="text-center">

                    <?php if ( $title_light ) : ?>
                        <span class="light"><?php echo esc_html( $title_light );?></span>
                    <?php endif; ?>

                    <?php if ( $title_bold ) : ?>
                        <span class="extra-bold"><?php echo esc_html( $title_bold );?></span>
                    <?php endif; ?>

                </h1>

                <div class="zigzag"><i class="<?php echo esc_html( get_sub_field('ps_ltstpsts_icon') );?>"></i></div>

            <?php endif; ?>


            <?php if ( $excerpt ) : ?>

                <div class="row">

                    <div class="col-md-offset-3 col-md-6">

                        <p class="text-center lead"><?php echo esc_html( $excerpt );?></p>

                    </div>

                </div>

            <?php endif; ?>

            <div class="row">

                <div class="pistacia-isotopes" data-post-per-page="8">

                    <div class="isotope-grids" id="isotope-grids"></div>

                    <div class="item-loading center-block text-center">
                        <img src="<?php echo get_template_directory_uri();?>/assets/img/loader_grey.gif">
                    </div>

                </div>

            </div>

        </div>

    </div>

</section>

<section class="more-button-section">
    <div class="text-center">
        <a href="#"
           class="btn btn-append more-posts-button tool-tip"
           id="more-post-button"
           data-paged="1"
           data-toggle="tooltip"
           data-placement="top"
           data-original-title="<?php esc_attr_e('More posts','pistacia');?>">
            <i class="fa fa-angle-down"></i>
        </a>
    </div>
</section>


