<?php
/**
 * ps_bldr_gmap.php
 *
 * This file contains google map block
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php $title_light = get_sub_field('pistacia_gmp_title_l'); ?>
<?php $title_bold = get_sub_field('pistacia_gmp_title_b'); ?>
<?php $excerpt = get_sub_field('pistacia_gmp_excerpt'); ?>

<section id="ourRestaurant" class="our-restaurant">

    <?php if( $title_light || $title_bold || $excerpt ) : ?>

        <div class="container">

            <h1 class="text-center">

                <?php if ( $title_light ) : ?>
                    <span class="light"><?php echo esc_html( $title_light );?></span>
                <?php endif; ?>

                <?php if ( $title_bold ) : ?>
                    <span class="extra-bold"><?php echo esc_html( $title_bold );?></span>
                <?php endif; ?>

            </h1>

            <div class="zigzag"><i class="<?php echo esc_html( get_sub_field('ps_gmp_icon') );?>"></i></div>

            <div class="row">

                <div class="col-md-offset-3 col-md-6">

                    <?php if ( $excerpt ) : ?>

                        <p class="text-center lead"><?php echo esc_html( $excerpt );?></p>

                    <?php endif; ?>

                </div>

            </div>

        </div>

    <?php endif; ?>

    <div class="google-maps"
        id="map-canvas"
        data-lat="<?php echo esc_attr(get_sub_field('ps_gmp_map_lat'));?>"
        data-lng="<?php echo esc_attr(get_sub_field('ps_gmp_map_lng'));?>"
        data-zoom="<?php echo esc_attr(get_sub_field('ps_gmp_map_zoom'));?>">
        <?php if( get_sub_field('pistacia_gmp_markers') ):?>
            <?php foreach( get_sub_field('pistacia_gmp_markers') as $marker ) : ?>
                <div class="marker"
                    data-text="<?php echo wp_kses_post($marker['ps_gmpm_map_text']);?>"
                    data-lat="<?php echo esc_attr($marker['ps_gmpm_map_lat']);?>"
                    data-lng="<?php echo esc_attr($marker['ps_gmpm_map_lng']);?>">
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

</section>
