<?php
/**
 * ps_bldr_galleries.php
 *
 * This file contains galleries
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php if(class_exists('Pistacia_Gallery_Manager')) : ?>

    <?php $item_perpage = ( get_sub_field('ps_glrs_number')) ? get_sub_field('ps_glrs_number') : '8'; ?>
    <?php $title_light = get_sub_field('ps_glrs_title_l');?>
    <?php $title_bold = get_sub_field('ps_glrs_title_b');?>
    <?php $excerpt = get_sub_field('ps_glrs_excerpt'); ?>

    <?php $gallery = new WP_Query(array(
        'post_type' => 'gallery',
        'posts_per_page' => $item_perpage,
        'paged' => 1
    )); ?>

    <section class="portfolio" id="portfolio">

        <div class="container">

            <?php if ( $title_light || $title_bold ) : ?>

                <h1 class="text-center">

                    <?php if ( $title_light ) : ?>
                        <span class="light"><?php echo esc_html( $title_light );?></span>
                    <?php endif; ?>

                    <?php if ( $title_bold ) : ?>
                        <span class="extra-bold"><?php echo esc_html( $title_bold );?></span>
                    <?php endif; ?>

                </h1>

                <div class="zigzag"><i class="<?php echo esc_html( get_sub_field('ps_glrs_icon') );?>"></i></div>

            <?php endif; ?>


            <?php if ( $excerpt ) : ?>

                <div class="row">

                    <div class="col-md-offset-3 col-md-6">

                        <p class="text-center lead"><?php echo esc_html( $excerpt );?></p>

                    </div>

                </div>

            <?php endif; ?>

            <div class="text-center">

                <ul class="list-tabs portfolio-filters">

                    <li class="active"><a data-filter="*" href="#">All</a></li>

                    <?php $cats = array();

                    while( $gallery->have_posts( ) ){
                        $gallery->the_post();
                        $terms = get_the_terms( get_the_ID(),'gallery_category' );
                        foreach( $terms as $term ){
                            if ( !in_array( $term->slug,$cats ) ){
                                array_push( $cats, $term->slug ); ?>
                                <li><a data-filter=".<?php echo esc_html($term->slug); ?>" href="#"><?php echo esc_html( $term->slug ); ?></a></li>
                            <?php }
                        }
                    } ?>

                </ul>

            </div>

            <ul class="portfolio-items">

                <?php while( $gallery->have_posts()): $gallery->the_post(); ?>

                    <?php $image_id = get_post_thumbnail_id();
                    $image_url = wp_get_attachment_image_src( $image_id, 'medium', false);
                    $terms = get_the_terms( get_the_ID(),'gallery_category' ); ?>

                    <?php if ( !empty( $image_url ) ) : ?>

                        <li class="item <?php foreach( $terms as $term ){ echo esc_attr($term->slug).' '; } ?>" data-category="<?php foreach( $terms as $term ){ echo esc_attr($term->slug).' '; } ?>">
                            <div class="item-container">
                                <figure>
                                    <img src="<?php echo esc_url($image_url[0]); ?>" alt="">
                                    <figcaption>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <h3><?php the_title(); ?></h3>
                                                <a href="<?php the_permalink(); ?>"><?php esc_html_e('Take a look','pistacia'); ?></a>
                                            </div>
                                        </div>
                                    </figcaption>
                                </figure>
                            </div>
                        </li>

                    <?php endif; ?>

                <?php endwhile; ?>

            </ul>

        </div>

    </section>

    <?php wp_reset_postdata(); ?>

<?php endif; ?>
