<?php
/**
 * ps_bldr_counterup.php
 *
 * This file contains counter up block
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */
?>

<?php $img_src = (get_sub_field('pistacia_cntrp_image')) ? get_sub_field('pistacia_cntrp_image') : get_template_directory_uri().'/assets/img/footer_background.jpg'; ?>
<?php $title_light = get_sub_field('pistacia_cntrp_title_l'); ?>
<?php $title_bold = get_sub_field('pistacia_cntrp_title_b'); ?>
<?php $counters = get_sub_field('pistacia_cntrp_counters'); ?>

<section id="specialServices" class="special-services">

    <div id="counterParallax" class="counter-parallax" style="background-image:url('<?php echo esc_url($img_src); ?>')">

        <div class="overlay overlay-black-70"></div>

        <div class="container container-inner">

            <?php if(  $title_light ||  $title_bold ) : ?>

            <div class="quote text-center">

                <h1 class="white-color">
                    <?php if (  $title_light ) : ?>
                        <span class="light"><?php echo esc_html(  $title_light );?></span>
                    <?php endif; ?>

                    <?php if (  $title_bold ) : ?>
                        <span class="extra-bold"><?php echo esc_html(  $title_bold );?></span>
                    <?php endif; ?>
                </h1>

            </div>

            <?php endif; ?>

            <div class="counters">

                <?php if($counters ):?>

                    <?php $count = 1; ?>

                    <?php foreach( $counters as $marker ) : ?>
                        <div class="col-sm-3 col-xs-6">
                            <div class="counter text-center rotateInDown<?php if ( $count % 2 == 0 ) { echo 'Left'; } else { echo 'Right'; } ?>-ifAppeared">
                                <div class="number counter-number" id="counterNumber<?php echo ( $count ); ?>"><?php echo esc_html( $marker['ps_cntrpc_number'] ); ?></div>
                                <p><?php echo esc_html( $marker['ps_cntrpc_title'] );?></p>
                                <?php $count++; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>

                <?php endif; ?>

            </div>

        </div>

    </div>

</section>
